/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.preanalyzed;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.NormsFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;

public class PreAnalyzedMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "preanalyzed";
    private FieldType fieldTypeText;
    private MappedFieldType fieldTypeIndexed;
    private static final JsonFactory jsonFactory = new JsonFactory();

    public PreAnalyzedMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, FieldType fieldTypeText, MappedFieldType fieldTypeIndexed) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.fieldTypeText = fieldTypeText;
        this.fieldTypeIndexed = fieldTypeIndexed;
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        String preAnalyzedJson = context.parser().textOrNull();
        if (null == preAnalyzedJson) {
            return;
        }
        try (JsonXContentParser parser = new JsonXContentParser(null, jsonFactory.createParser(preAnalyzedJson));){
            Field field;
            TokenStream ts;
            Tuple<PreAnalyzedStoredValue, TokenStream> valueAndTokenStream;
            try {
                valueAndTokenStream = this.parsePreAnalyzedFieldContents((XContentParser)parser);
            }
            catch (MapperParsingException e) {
                throw new MapperParsingException("Could not read preanalyzed field value of document", (Throwable)e);
            }
            if (this.fieldType().indexOptions() != IndexOptions.NONE && this.fieldType().tokenized() && (ts = (TokenStream)valueAndTokenStream.v2()) != null) {
                field = new Field(this.fieldTypeIndexed.name(), ts, (IndexableFieldType)this.fieldTypeIndexed);
                fields.add((IndexableField)field);
            }
            PreAnalyzedStoredValue storedValue = (PreAnalyzedStoredValue)valueAndTokenStream.v1();
            if (this.fieldTypeText.stored() && null != storedValue.value) {
                field = PreAnalyzedStoredValue.VALUE_TYPE.STRING == storedValue.type ? new Field(this.fieldType().name(), (String)storedValue.value, (IndexableFieldType)this.fieldTypeText) : new Field(this.fieldType().name(), (BytesRef)storedValue.value, (IndexableFieldType)this.fieldTypeText);
                fields.add((IndexableField)field);
            }
        }
    }

    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        this.doXContentAnalyzers(builder, includeDefaults);
    }

    private Tuple<PreAnalyzedStoredValue, TokenStream> parsePreAnalyzedFieldContents(XContentParser parser) {
        try {
            XContentParser.Token currentToken = parser.currentToken();
            String currentFieldName = "";
            String version = null;
            PreAnalyzedStoredValue storedValue = new PreAnalyzedStoredValue();
            PreAnalyzedTokenStream ts = null;
            while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (currentToken == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (currentToken == XContentParser.Token.VALUE_STRING) {
                    if ("v".equals(currentFieldName)) {
                        version = parser.text();
                        if ("1".equals(version)) continue;
                        throw new MapperParsingException("Version of pre-analyzed field format is \"" + version + "\" which is not supported.");
                    }
                    if ("str".equals(currentFieldName)) {
                        storedValue.value = parser.text();
                        storedValue.type = PreAnalyzedStoredValue.VALUE_TYPE.STRING;
                        continue;
                    }
                    if (!"bin".equals(currentFieldName)) continue;
                    storedValue.value = parser.binaryValue();
                    storedValue.type = PreAnalyzedStoredValue.VALUE_TYPE.BINARY;
                    continue;
                }
                if (!"tokens".equals(currentFieldName) || currentToken != XContentParser.Token.START_ARRAY) continue;
                ts = new PreAnalyzedTokenStream(parser);
            }
            if (null == version) {
                throw new MapperParsingException("No version of pre-analyzed field format has been specified for field " + this.fieldType().name());
            }
            return new Tuple((Object)storedValue, ts);
        }
        catch (IOException e) {
            throw new MapperParsingException("The input document could not be parsed as a preanalyzed field value for field " + this.fieldType().name() + ".", (Throwable)e);
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    private static class PreAnalyzedStoredValue {
        Object value;
        VALUE_TYPE type;

        private PreAnalyzedStoredValue() {
        }

        static enum VALUE_TYPE {
            STRING,
            BINARY;

        }
    }

    public static class PreAnalyzedTokenStream
    extends TokenStream {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private final PayloadAttribute payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
        private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
        private final FlagsAttribute flagsAtt = (FlagsAttribute)this.addAttribute(FlagsAttribute.class);
        private XContentParser parser;
        private ArrayList<Map<String, Object>> tokenList;
        private int tokenIndex;

        PreAnalyzedTokenStream(XContentParser parser) throws IOException {
            this.parser = parser;
            this.parsePreanalyzedTokens();
            this.reset();
        }

        private void parsePreanalyzedTokens() throws NumberFormatException, IOException {
            XContentParser.Token currentToken;
            this.tokenList = new ArrayList();
            if (this.parser.currentToken() != XContentParser.Token.START_ARRAY) {
                throw new IllegalStateException("The parser is expected to point to the beginning of the array of preanalyzed tokens but the current token type was " + this.parser.currentToken());
            }
            HashMap<String, Object> tokenMap = null;
            while ((currentToken = this.parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (currentToken == XContentParser.Token.START_OBJECT) {
                    tokenMap = new HashMap<String, Object>();
                }
                this.clearAttributes();
                boolean termFound = false;
                int start = -1;
                int end = -1;
                String currentFieldName = null;
                while ((currentToken = this.parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (currentToken == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = this.parser.currentName();
                        continue;
                    }
                    if (currentToken == XContentParser.Token.VALUE_STRING) {
                        if ("t".equals(currentFieldName)) {
                            char[] tokenBuffer = this.parser.textCharacters();
                            char[] bufferCopy = new char[this.parser.textLength()];
                            System.arraycopy(tokenBuffer, this.parser.textOffset(), bufferCopy, 0, bufferCopy.length);
                            tokenMap.put("t", bufferCopy);
                            termFound = true;
                            continue;
                        }
                        if ("p".equals(currentFieldName)) {
                            BytesRef inputBytes = this.parser.utf8Bytes();
                            byte[] byteArray = new byte[inputBytes.length];
                            System.arraycopy(inputBytes.bytes, 0, byteArray, 0, inputBytes.length);
                            BytesRef bytesRef = new BytesRef(byteArray);
                            tokenMap.put("p", bytesRef);
                            continue;
                        }
                        if ("f".equals(currentFieldName)) {
                            tokenMap.put("f", Integer.decode(this.parser.text()));
                            continue;
                        }
                        if (!"y".equals(currentFieldName)) continue;
                        tokenMap.put("y", this.parser.text());
                        continue;
                    }
                    if (currentToken != XContentParser.Token.VALUE_NUMBER) continue;
                    if ("s".equals(currentFieldName)) {
                        start = this.parser.intValue();
                        continue;
                    }
                    if ("e".equals(currentFieldName)) {
                        end = this.parser.intValue();
                        continue;
                    }
                    if (!"i".equals(currentFieldName)) continue;
                    tokenMap.put("i", this.parser.intValue());
                }
                tokenMap.put("s", start != -1 ? start : 0);
                tokenMap.put("e", end != -1 ? end : 0);
                if (!termFound) {
                    throw new IllegalArgumentException("There is at least one token object in the pre-analyzed field value where no actual term string is specified.");
                }
                this.tokenList.add(tokenMap);
            }
        }

        public final boolean incrementToken() throws IOException {
            if (this.tokenIndex < this.tokenList.size()) {
                Map<String, Object> t = this.tokenList.get(this.tokenIndex);
                char[] termChars = (char[])t.get("t");
                BytesRef payload = (BytesRef)t.get("p");
                Integer flags = (Integer)t.get("f");
                String type = (String)t.get("y");
                Integer start = (Integer)t.get("s");
                Integer end = (Integer)t.get("e");
                Integer posInc = (Integer)t.get("i");
                try {
                    this.clearAttributes();
                    if (null != termChars) {
                        this.termAtt.copyBuffer(termChars, 0, termChars.length);
                    }
                    if (null != payload) {
                        this.payloadAtt.setPayload(payload);
                    }
                    if (null != flags) {
                        this.flagsAtt.setFlags(flags.intValue());
                    }
                    if (null != type) {
                        this.typeAtt.setType(type);
                    }
                    if (null != posInc) {
                        this.posIncrAtt.setPositionIncrement(posInc.intValue());
                    }
                    if (null != start && null != end && -1 != start && -1 != end) {
                        this.offsetAtt.setOffset(start.intValue(), end.intValue());
                        ++this.tokenIndex;
                        return true;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception occurred at token term: " + new String(termChars) + ", start: " + start + ", end: " + end + ", positionIncrement: " + posInc, e);
                }
            }
            return false;
        }

        public void reset() throws IOException {
            this.tokenIndex = 0;
        }
    }

    public static final class PreanalyzedFieldType
    extends StringFieldType {
        public PreanalyzedFieldType() {
        }

        public PreanalyzedFieldType(PreanalyzedFieldType ref) {
            super((MappedFieldType)ref);
        }

        public MappedFieldType clone() {
            return new PreanalyzedFieldType(this);
        }

        public String typeName() {
            return PreAnalyzedMapper.CONTENT_TYPE;
        }

        public Query existsQuery(QueryShardContext context) {
            if (this.omitNorms()) {
                return new TermQuery(new Term("_field_names", this.name()));
            }
            return new NormsFieldExistsQuery(this.name());
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseTextField((FieldMapper.Builder)builder, (String)name, node, (Mapper.TypeParser.ParserContext)parserContext);
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, PreAnalyzedMapper> {
        protected Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public PreAnalyzedMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            FieldType fieldTypeText = new FieldType((IndexableFieldType)this.fieldType);
            fieldTypeText.setIndexOptions(IndexOptions.NONE);
            fieldTypeText.setTokenized(false);
            fieldTypeText.setStored(this.fieldType.stored());
            fieldTypeText.setStoreTermVectors(false);
            fieldTypeText.setStoreTermVectorPositions(false);
            fieldTypeText.setStoreTermVectorOffsets(false);
            fieldTypeText.setStoreTermVectorPayloads(false);
            MappedFieldType fieldTypeIndexed = this.fieldType.clone();
            fieldTypeIndexed.setStored(false);
            return new PreAnalyzedMapper(this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build((FieldMapper.Builder)this, context), this.copyTo, fieldTypeText, fieldTypeIndexed);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new PreanalyzedFieldType();

        static {
            FIELD_TYPE.freeze();
        }
    }
}

