/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.StringTokenizer;
import java.util.Vector;

public class WildCardFilter
implements FilenameFilter {
    String wildPattern = null;
    Vector pattern = new Vector();
    final String FIND = "find";
    final String EXPECT = "expect";
    final String ANYTHING = "anything";
    final String NOTHING = "nothing";

    public WildCardFilter(String wildString) {
        this.wildPattern = wildString;
        wildString = wildString.toLowerCase();
        int i = wildString.indexOf("**");
        while (i >= 0) {
            wildString = wildString.substring(0, i + 1) + wildString.substring(i + 2);
            i = wildString.indexOf("**");
        }
        StringTokenizer tokens = new StringTokenizer(wildString, "*", true);
        String token = null;
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            if (token.equals("*")) {
                this.pattern.addElement("find");
                if (tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    this.pattern.addElement(token);
                    continue;
                }
                this.pattern.addElement("anything");
                continue;
            }
            this.pattern.addElement("expect");
            this.pattern.addElement(token);
        }
        if (!token.equals("*")) {
            this.pattern.addElement("expect");
            this.pattern.addElement("nothing");
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        File tempFile;
        String path = dir.getPath();
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + File.separator;
        }
        if ((tempFile = new File(path, name)).isDirectory()) {
            return true;
        }
        name = name.toLowerCase();
        boolean acceptName = true;
        String command = null;
        String param = null;
        int currPos = 0;
        for (int cmdPos = 0; cmdPos < this.pattern.size(); cmdPos += 2) {
            int nextPos;
            command = (String)this.pattern.elementAt(cmdPos);
            param = (String)this.pattern.elementAt(cmdPos + 1);
            if (command.equals("find")) {
                if (param.equals("anything")) break;
                nextPos = name.indexOf(param, currPos);
                if (nextPos >= 0) {
                    currPos = nextPos + param.length();
                    continue;
                }
                acceptName = false;
                break;
            }
            if (!command.equals("expect")) continue;
            if (param.equals("nothing")) {
                if (currPos == name.length()) break;
                acceptName = false;
                break;
            }
            nextPos = name.indexOf(param, currPos);
            if (nextPos != currPos) {
                acceptName = false;
                break;
            }
            currPos += param.length();
        }
        return acceptName;
    }

    public String toString() {
        return this.wildPattern;
    }

    public String toPattern() {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < this.pattern.size(); i += 2) {
            out.append("(");
            out.append((String)this.pattern.elementAt(i));
            out.append(" ");
            out.append((String)this.pattern.elementAt(i + 1));
            out.append(") ");
        }
        return out.toString();
    }
}

