/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;

public class SimpleDictionary {
    private SortedArray list;
    private boolean caseSensitive;

    public SimpleDictionary() {
        this(false);
    }

    public SimpleDictionary(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.list = new SortedArray();
    }

    public SimpleDictionary(String dictFile) {
        this(dictFile, false);
    }

    public SimpleDictionary(String dictFile, boolean caseSensitive) {
        this.list = SimpleDictionary.loadList(dictFile, caseSensitive);
        this.caseSensitive = caseSensitive;
    }

    public void add(String word) {
        if (this.caseSensitive) {
            this.list.add(word);
        } else {
            this.list.add(word.toLowerCase());
        }
    }

    public boolean exist(String word) {
        if (word == null) {
            return false;
        }
        if (this.caseSensitive) {
            return this.list.binarySearch(word) >= 0;
        }
        return this.list.binarySearch(word.toLowerCase()) >= 0;
    }

    public static void merge(String inputFolder, String outputFile, boolean caseSensitive) {
        int i;
        File folder = new File(inputFolder);
        if (!folder.exists()) {
            return;
        }
        if (!folder.isDirectory()) {
            return;
        }
        File[] arrFile = folder.listFiles();
        SortedArray list = new SortedArray();
        for (i = 0; i < arrFile.length; ++i) {
            SimpleDictionary.loadList(inputFolder + "/" + arrFile[i].getName(), list, caseSensitive);
        }
        try {
            BufferedWriter bw = FileUtil.getTextWriter(outputFile);
            for (i = 0; i < list.size(); ++i) {
                bw.write((String)list.get(i) + "\n");
            }
            list.clear();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SortedArray loadList(String filename, boolean caseSensitive) {
        SortedArray list = new SortedArray();
        SimpleDictionary.loadList(filename, list, caseSensitive);
        return list;
    }

    public static void loadList(String filename, SortedArray list, boolean caseSensitive) {
        try {
            if (filename == null || filename.trim().length() == 0) {
                return;
            }
            if (!FileUtil.exist(filename) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + filename)) {
                filename = EnvVariable.getDragonHome() + "/" + filename;
            }
            BufferedReader br = FileUtil.getTextReader(filename);
            String line = br.readLine().trim();
            try {
                Integer.parseInt(line);
                line = "";
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (line != null) {
                if ((line = line.trim()).length() == 0) {
                    line = br.readLine();
                    continue;
                }
                int pos = line.indexOf(9);
                if (pos > 0) {
                    line = line.substring(0, pos);
                }
                if (!caseSensitive) {
                    list.add(line.toLowerCase());
                } else {
                    list.add(line);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

