/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

public class MathUtil {
    public static double LOG0 = -1.7976931348623157E308;
    public static double LOG2 = 0.69314718055;
    private static final double MINUS_LOG_EPSILON = 30.0;

    public static void initArray(double[] array, double initVal) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = initVal;
        }
    }

    public static void initArray(int[] array, int initVal) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = initVal;
        }
    }

    public static void copyArray(double[] srcArray, double[] destArray) {
        for (int i = 0; i < srcArray.length; ++i) {
            destArray[i] = srcArray[i];
        }
    }

    public static void multiArray(double[] array, double multiplier) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] * multiplier;
        }
    }

    public static double sumArray(double[] array) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static int sumArray(int[] array) {
        int sum = 0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static void sumArray(double[] array, double[] incArray) {
        for (int i = 0; i < array.length; ++i) {
            int n = i;
            array[n] = array[n] + incArray[i];
        }
    }

    public static double max(double[] array) {
        double max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] > max)) continue;
            max = array[i];
        }
        return max;
    }

    public static int max(int[] array) {
        int max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return max;
    }

    public static double min(double[] array) {
        double min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] < min)) continue;
            min = array[i];
        }
        return min;
    }

    public static int min(int[] array) {
        int min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return min;
    }

    public static double average(double[] array) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        return sum / (double)array.length;
    }

    public static double average(int[] array) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += (double)array[i];
        }
        return sum / (double)array.length;
    }

    public static int maxElementInArray(double[] array) {
        double max = array[0];
        int maxIndex = 0;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] > max)) continue;
            max = array[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static int maxElementInArray(int[] array) {
        double max = array[0];
        int maxIndex = 0;
        for (int i = 1; i < array.length; ++i) {
            if (!((double)array[i] > max)) continue;
            max = array[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    public static int[] rankElementInArray(double[] array, boolean desc) {
        int[] rank = new int[array.length];
        MathUtil.initArray(rank, -1);
        for (int i = 0; i < array.length; ++i) {
            int count = 0;
            for (int j = 0; j < array.length; ++j) {
                if (!(array[j] > array[i])) continue;
                ++count;
            }
            if (desc) {
                while (rank[count] >= 0) {
                    ++count;
                }
                rank[count] = i;
                continue;
            }
            while (rank[array.length - 1 - count] >= 0) {
                ++count;
            }
            rank[array.length - 1 - count] = i;
        }
        return rank;
    }

    public static int[] rankElementInArray(int[] array, boolean desc) {
        int[] rank = new int[array.length];
        MathUtil.initArray(rank, -1);
        for (int i = 0; i < array.length; ++i) {
            int count = 0;
            for (int j = 0; j < array.length; ++j) {
                if (array[j] <= array[i]) continue;
                ++count;
            }
            if (desc) {
                while (rank[count] >= 0) {
                    ++count;
                }
                rank[count] = i;
                continue;
            }
            while (rank[array.length - 1 - count] >= 0) {
                ++count;
            }
            rank[array.length - 1 - count] = i;
        }
        return rank;
    }

    public static double exp(double d) {
        if (Double.isInfinite(d) || d < 0.0 && Math.abs(d) > 30.0) {
            return 0.0;
        }
        return Math.exp(d);
    }

    public static double log(double val) {
        return Math.abs(val - 1.0) < Double.MIN_VALUE ? 0.0 : Math.log(val);
    }

    public static double logSumExp(double v1, double v2) {
        if (Math.abs(v1 - v2) < Double.MIN_VALUE) {
            return v1 + LOG2;
        }
        double vmin = Math.min(v1, v2);
        double vmax = Math.max(v1, v2);
        if (vmax > vmin + 30.0) {
            return vmax;
        }
        return vmax + Math.log(Math.exp(vmin - vmax) + 1.0);
    }

    public static void logSumExp(double[] v1, double[] v2) {
        for (int i = 0; i < v1.length; ++i) {
            v1[i] = MathUtil.logSumExp(v1[i], v2[i]);
        }
    }

    public static double logSumExp(double[] logArray) {
        double ret = logArray[0];
        for (int i = 1; i < logArray.length; ++i) {
            ret = MathUtil.logSumExp(ret, logArray[i]);
        }
        return ret;
    }
}

