/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

import dragon.util.ByteArrayConvert;
import dragon.util.FileUtil;
import dragon.util.HttpContent;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class HttpUtil {
    private HttpClient http;
    private String defaultCharSet;
    private String lastCharSet = null;
    private byte[] buf = new byte[0x100000];
    private boolean autoRefresh = false;

    public static void main(String[] args) {
        HttpUtil web = new HttpUtil("www.google.com");
        web.setAutoRefresh(true);
        String content = web.get("/search?q=killed+abraham+lincoln&hl=en&newwindow=1&rlz=1T4GZHY_enUS237US237&start=40&sa=N");
        FileUtil.saveTextFile("test.txt", content, "UTF-16LE");
        FileUtil.saveTextFile("test_notag.txt", new HttpContent().extractText(content), "UTF-16LE");
    }

    public HttpUtil(String host) {
        this(host, 80, null);
    }

    public HttpUtil(String host, String charSet) {
        this(host, 80, charSet);
    }

    public HttpUtil(String host, int port) {
        this(host, port, null);
    }

    public HttpUtil(String host, int port, String charSet) {
        this.defaultCharSet = charSet;
        this.http = new HttpClient();
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(host, port);
        this.http.setHostConfiguration(hostConfig);
        this.setSocketTimeout(10000);
        this.setConnectionTimeout(10000);
    }

    public void setHost(String host) {
        this.setHost(host, 80, null);
    }

    public void setHost(String host, String charSet) {
        this.setHost(host, 80, charSet);
    }

    public void setHost(String host, int port) {
        this.setHost(host, port, this.defaultCharSet);
    }

    public void setHost(String host, int port, String charSet) {
        this.defaultCharSet = charSet;
        HostConfiguration hostConfig = this.http.getHostConfiguration();
        hostConfig.setHost(host, port);
        this.http.setHostConfiguration(hostConfig);
    }

    public void setAutoRefresh(boolean enable) {
        this.autoRefresh = enable;
    }

    public boolean getAutoRefresh() {
        return this.autoRefresh;
    }

    public String getHost() {
        return this.http.getHostConfiguration().getHost();
    }

    public int getPort() {
        return this.http.getHostConfiguration().getPort();
    }

    public void setConnectionTimeout(int time) {
        this.http.getHttpConnectionManager().getParams().setConnectionTimeout(time);
    }

    public int getConnectionTimeout() {
        return this.http.getHttpConnectionManager().getParams().getConnectionTimeout();
    }

    public void setSocketTimeout(int time) {
        this.http.getParams().setParameter("http.socket.timeout", (Object)new Integer(time));
    }

    public int getSocketTimeout() {
        return (Integer)this.http.getParams().getParameter("http.socket.timeout");
    }

    public String getCharSet() {
        return this.lastCharSet;
    }

    public String get(String url) {
        return this.get(url, null);
    }

    public String get(String url, String charSet) {
        String content = this.internalGet(url, charSet);
        if (content == null || !this.autoRefresh) {
            return content;
        }
        URL newUrl = this.getDirectedURL(content);
        if (newUrl == null) {
            return content;
        }
        if (newUrl.getHost() != "") {
            if (newUrl.getPort() > 0) {
                this.setHost(newUrl.getHost(), newUrl.getPort());
            } else {
                this.setHost(newUrl.getHost());
            }
        }
        url = newUrl.getFile();
        while (url.charAt(0) == '.') {
            url = url.substring(1);
        }
        if (url.charAt(0) != '/') {
            url = "/" + url;
        }
        return this.internalGet(url, charSet);
    }

    private URL getDirectedURL(String message) {
        try {
            if (message == null || message.length() >= 512) {
                return null;
            }
            int start = (message = message.toLowerCase()).indexOf("http-equiv=\"refresh\"");
            if (start < 0) {
                start = message.indexOf("http-equiv='refresh'");
            }
            if (start < 0) {
                return null;
            }
            int end = message.indexOf(">", start);
            if (end < 0) {
                return null;
            }
            if ((start = (message = message.substring(start, end)).indexOf("url=")) < 0) {
                return null;
            }
            end = message.indexOf("\"", start += 4);
            if (end < 0) {
                end = message.indexOf("'", start);
            }
            if (!(message = message.substring(start, end)).startsWith("http")) {
                message = "http:" + message;
            }
            URL url = new URL(message);
            return url;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String internalGet(String url, String charSet) {
        GetMethod method = null;
        try {
            String content;
            method = new GetMethod(url);
            method.getParams().setCookiePolicy("compatibility");
            this.http.executeMethod((HttpMethod)method);
            if (method.getStatusCode() != 200) {
                method.releaseConnection();
                return null;
            }
            int len = this.read(method.getResponseBodyAsStream(), this.buf);
            String curCharSet = this.recognizeStreamEncode(this.buf);
            if (curCharSet == null) {
                curCharSet = charSet;
            }
            if (curCharSet == null) {
                curCharSet = method.getResponseCharSet();
            }
            if (curCharSet != null && curCharSet.equalsIgnoreCase("ISO-8859-1")) {
                curCharSet = null;
            }
            if (curCharSet != null) {
                content = new String(this.buf, 0, len, this.charsetNameConvert(curCharSet));
            } else {
                if (this.defaultCharSet != null) {
                    curCharSet = this.defaultCharSet;
                    content = new String(this.buf, 0, len, this.charsetNameConvert(curCharSet));
                } else {
                    content = new String(this.buf, 0, len);
                }
                charSet = this.readCharSet(content);
                if (charSet != null && !this.compatibleCharSet(curCharSet, charSet)) {
                    curCharSet = charSet;
                    content = new String(this.buf, 0, len, this.charsetNameConvert(curCharSet));
                }
            }
            this.lastCharSet = curCharSet;
            method.releaseConnection();
            return content;
        }
        catch (Exception e) {
            if (method != null) {
                method.releaseConnection();
            }
            return null;
        }
    }

    private int read(InputStream in, byte[] buf) {
        try {
            int offset = 0;
            int len = in.read(buf);
            while (len >= 0 && (offset += len) != buf.length) {
                len = in.read(buf, offset, buf.length - offset);
            }
            if (offset == buf.length) {
                System.out.println("Warning: The web page is too big and truncated!");
            }
            return offset;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private boolean compatibleCharSet(String charsetA, String charsetB) {
        if (charsetA == null || charsetB == null) {
            return false;
        }
        if (charsetA.equalsIgnoreCase(charsetB)) {
            return true;
        }
        return charsetA.equalsIgnoreCase("gbk") && charsetB.equalsIgnoreCase("gb2312");
    }

    private String charsetNameConvert(String charsetName) {
        if (charsetName.equalsIgnoreCase("gb2312")) {
            return "gbk";
        }
        return charsetName;
    }

    private String recognizeStreamEncode(byte[] buf) {
        try {
            String hex = ByteArrayConvert.toHexString(buf, 0, 3).toUpperCase();
            if (hex.startsWith("FFFE") || hex.startsWith("3C00")) {
                return "UTF-16LE";
            }
            if (hex.startsWith("FEFF") || hex.startsWith("003C")) {
                return "UTF-16BE";
            }
            if (hex.startsWith("EFBBBF")) {
                return "UTF-8";
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String readCharSet(String message) {
        try {
            int end = Math.min(message.length(), 2048);
            message = message.substring(0, end).toLowerCase();
            int start = message.indexOf("http-equiv=");
            if (start < 0) {
                return null;
            }
            end = message.indexOf(">", start);
            if ((start = (message = message.substring(start, end).trim()).indexOf("charset=")) < 0) {
                return null;
            }
            end = message.indexOf("\"", start += 8);
            if (end < 0) {
                end = message.indexOf("'", start);
            }
            if (end < 0) {
                return null;
            }
            return message.substring(start, end).trim();
        }
        catch (Exception e) {
            return null;
        }
    }
}

