/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class FastFileInputStream
extends InputStream {
    private byte[] buf;
    private int buf_length;
    private int buf_pos;
    private long available;
    private FileInputStream fis;
    private RandomAccessFile raf;
    private int inputType;
    private boolean class_open_file;

    public FastFileInputStream(String filename) {
        try {
            File f = new File(filename);
            this.available = f.length();
            this.fis = new FileInputStream(f);
            this.raf = null;
            this.buf_length = 512;
            this.buf = new byte[this.buf_length];
            this.buf_pos = this.buf_length;
            this.inputType = 1;
            this.class_open_file = true;
        }
        catch (Exception e) {
            this.fis = null;
            e.printStackTrace();
        }
    }

    public FastFileInputStream(File f) {
        try {
            this.available = f.length();
            this.fis = new FileInputStream(f);
            this.raf = null;
            this.buf_length = 512;
            this.buf = new byte[this.buf_length];
            this.buf_pos = this.buf_length;
            this.inputType = 1;
            this.class_open_file = true;
        }
        catch (Exception e) {
            this.fis = null;
            e.printStackTrace();
        }
    }

    public FastFileInputStream(RandomAccessFile raf, long length) {
        this.buf_length = 512;
        this.buf = new byte[this.buf_length];
        this.buf_pos = this.buf_length;
        this.raf = raf;
        this.fis = null;
        this.available = length;
        this.inputType = 2;
        this.class_open_file = false;
    }

    @Override
    public int read() throws IOException {
        this.refillBuffer();
        if (this.available <= 0L) {
            return -1;
        }
        ++this.buf_pos;
        --this.available;
        return this.buf[this.buf_pos - 1] & 0xFF;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        this.refillBuffer();
        if (this.available <= 0L) {
            return -1;
        }
        int count = this.buf_length - this.buf_pos;
        if (this.available < (long)len) {
            len = (int)this.available;
        }
        if (len <= count) {
            System.arraycopy(this.buf, this.buf_pos, buffer, off, len);
            this.buf_pos += len;
            this.available -= (long)len;
            return len;
        }
        System.arraycopy(this.buf, this.buf_pos, buffer, off, count);
        this.buf_pos = this.buf_length;
        int left = this.internalRead(buffer, off + count, len - count);
        if (left <= 0) {
            this.available = 0L;
            return count;
        }
        this.available -= (long)(count + left);
        return count + left;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public void reset() {
    }

    @Override
    public long skip(long n) throws IOException {
        int count;
        if (this.available < n) {
            n = this.available;
        }
        if (n <= (long)(count = this.buf_length - this.buf_pos)) {
            this.buf_pos = (int)((long)this.buf_pos + n);
            this.available -= n;
            return n;
        }
        this.buf_pos = this.buf_length;
        long left = this.internalSkip(n - (long)count);
        this.available = this.available - (long)count - left;
        return (long)count + left;
    }

    @Override
    public int available() {
        return (int)this.available;
    }

    public long remaining() {
        return this.available;
    }

    @Override
    public void close() throws IOException {
        if (this.class_open_file) {
            if (this.fis != null) {
                this.fis.close();
            }
            if (this.raf != null) {
                this.raf.close();
            }
        }
    }

    private void refillBuffer() {
        if (this.available <= 0L || this.buf_pos < this.buf_length) {
            return;
        }
        try {
            this.buf_length = this.internalRead(this.buf, 0, this.buf.length);
            this.buf_pos = 0;
        }
        catch (Exception e) {
            this.buf_length = 0;
            e.printStackTrace();
        }
    }

    private int internalRead(byte[] buffer, int off, int len) throws IOException {
        if (this.inputType == 1) {
            return this.fis.read(buffer, off, len);
        }
        return this.raf.read(buffer, off, len);
    }

    private long internalSkip(long n) throws IOException {
        if (this.inputType == 1) {
            return this.fis.skip(n);
        }
        return this.raf.skipBytes((int)n);
    }
}

