/*
 * Decompiled with CFR 0.152.
 */
package dragon.util;

import dragon.util.ByteArrayConvert;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;

public class ByteArrayWriter
implements DataOutput {
    private ByteArrayOutputStream baos;

    public ByteArrayWriter(int capacity) {
        this.baos = new ByteArrayOutputStream(capacity);
    }

    public ByteArrayWriter() {
        this.baos = new ByteArrayOutputStream();
    }

    @Override
    public void write(int value) throws IOException {
        this.baos.write(value);
    }

    @Override
    public void writeByte(int value) throws IOException {
        this.baos.write(value);
    }

    @Override
    public void writeBytes(String value) throws IOException {
        this.baos.write(value.getBytes());
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        if (value) {
            this.baos.write(1);
        } else {
            this.baos.write(0);
        }
    }

    @Override
    public void writeChar(int value) throws IOException {
        this.baos.write(ByteArrayConvert.toByte((char)value));
    }

    @Override
    public void writeChars(String value) throws IOException {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            this.baos.write(ByteArrayConvert.toByte(value.charAt(i)));
        }
    }

    @Override
    public void writeShort(int value) throws IOException {
        this.baos.write(ByteArrayConvert.toByte((short)value));
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.baos.write(ByteArrayConvert.toByte(value));
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.baos.write(ByteArrayConvert.toByte(value));
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.baos.write(ByteArrayConvert.toByte(value));
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.baos.write(ByteArrayConvert.toByte(value));
    }

    @Override
    public void write(byte[] value) throws IOException {
        this.baos.write(value);
    }

    @Override
    public void write(byte[] value, int off, int len) throws IOException {
        this.baos.write(value, off, len);
    }

    @Override
    public void writeUTF(String value) throws IOException {
        System.out.println("not implemented yet!");
    }

    public void reset() {
        this.baos.reset();
    }

    public int size() {
        return this.baos.size();
    }

    public byte[] toByteArray() {
        return this.baos.toByteArray();
    }

    public void close() throws IOException {
        this.baos.close();
    }
}

