/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb.trec;

import dragon.onlinedb.Article;
import dragon.onlinedb.ArticleParser;
import dragon.onlinedb.BasicArticleIndex;
import dragon.onlinedb.BasicArticleKey;
import dragon.onlinedb.CollectionReader;
import dragon.onlinedb.trec.TrecFileReader;
import java.io.File;
import java.io.RandomAccessFile;

public class TrecCollectionReader
implements CollectionReader {
    private CollectionReader curCollection;
    private BasicArticleIndex articleIndex;
    private RandomAccessFile curCacheFile;
    private int curCacheFileIndex;
    private String filename;
    private String collectionPath;
    private String indexFile;
    private byte[] buf;
    private File[] arrFile;
    private int curFileIndex;
    private int totalFileIndex;
    private ArticleParser parser;

    public TrecCollectionReader(ArticleParser parser) {
        this.curCollection = null;
        this.totalFileIndex = 0;
        this.curFileIndex = 0;
        this.arrFile = null;
        this.curCacheFileIndex = -1;
        this.curCacheFile = null;
        this.parser = parser;
    }

    private TrecCollectionReader(File folder, ArticleParser parser) {
        this.parser = parser;
        this.curCacheFileIndex = -1;
        this.curCacheFile = null;
        this.loadCollection(folder, null);
    }

    public TrecCollectionReader(String collectionPath, ArticleParser parser) {
        this(new File(collectionPath), parser);
    }

    public TrecCollectionReader(String collectionPath, String indexFile, ArticleParser parser) {
        this.parser = parser;
        this.curCacheFileIndex = -1;
        this.curCacheFile = null;
        this.loadCollection(new File(collectionPath), indexFile);
    }

    public boolean loadCollection(String collectionPath) {
        return this.loadCollection(collectionPath, null);
    }

    public boolean loadCollection(String collectionPath, String indexFile) {
        return this.loadCollection(new File(collectionPath), indexFile);
    }

    private boolean loadCollection(File folder, String indexFile) {
        this.close();
        this.indexFile = indexFile;
        this.articleIndex = indexFile == null ? null : (!new File(indexFile).exists() || new File(indexFile).length() <= 18L ? new BasicArticleIndex(indexFile, true) : new BasicArticleIndex(indexFile, false));
        if (!folder.isDirectory()) {
            this.arrFile = new File[1];
            this.arrFile[0] = folder;
            this.totalFileIndex = 1;
            this.filename = null;
        } else {
            this.filename = folder.getName();
            this.arrFile = folder.listFiles();
            this.totalFileIndex = this.arrFile.length;
        }
        this.collectionPath = folder.getPath();
        this.curFileIndex = 0;
        this.curCollection = this.arrFile[0].isDirectory() ? new TrecCollectionReader(this.arrFile[0], this.parser) : new TrecFileReader(this.arrFile[0], this.parser);
        return true;
    }

    @Override
    public ArticleParser getArticleParser() {
        return this.parser;
    }

    @Override
    public void setArticleParser(ArticleParser parser) {
        this.parser = parser;
        if (this.curCollection != null) {
            this.curCollection.setArticleParser(parser);
        }
    }

    @Override
    public Article getArticleByKey(String key) {
        try {
            if (this.articleIndex == null || this.articleIndex.isWritingMode()) {
                return null;
            }
            BasicArticleKey articleKey = this.articleIndex.search(key);
            if (articleKey == null) {
                return null;
            }
            if (articleKey.getFileIndex() != this.curCacheFileIndex) {
                if (this.curCacheFile != null) {
                    this.curCacheFile.close();
                }
                this.curCacheFileIndex = articleKey.getFileIndex();
                String curFilename = this.articleIndex.getFilename(this.curCacheFileIndex);
                curFilename = curFilename != null ? this.collectionPath + "/" + curFilename : this.collectionPath;
                this.curCacheFile = new RandomAccessFile(curFilename, "r");
            }
            this.curCacheFile.seek(articleKey.getOffset());
            if (this.buf == null || this.buf.length < articleKey.getLength()) {
                this.buf = new byte[articleKey.getLength() + 10240];
            }
            this.curCacheFile.read(this.buf, 0, articleKey.getLength());
            return this.parser.parse(new String(this.buf, 0, articleKey.getLength()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Article getNextArticle() {
        try {
            if (this.curCollection == null && this.parser == null) {
                return null;
            }
            Article cur = this.curCollection.getNextArticle();
            while (cur == null && this.curFileIndex < this.totalFileIndex - 1) {
                this.curCollection.close();
                ++this.curFileIndex;
                this.curCollection = this.arrFile[this.curFileIndex].isDirectory() ? new TrecCollectionReader(this.arrFile[this.curFileIndex], this.parser) : new TrecFileReader(this.arrFile[this.curFileIndex], this.parser);
                cur = this.curCollection.getNextArticle();
            }
            if (cur != null && this.articleIndex != null && this.articleIndex.isWritingMode()) {
                String curArticleFilename = this.getArticleFilename();
                if (curArticleFilename.indexOf("/") > 0) {
                    curArticleFilename = curArticleFilename.substring(curArticleFilename.indexOf("/") + 1);
                    this.articleIndex.add(cur.getKey(), curArticleFilename, this.getArticleOffset(), this.getArticleLength());
                } else {
                    this.articleIndex.add(cur.getKey(), this.getArticleOffset());
                }
            }
            return cur;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getArticleOffset() {
        if (this.curCollection == null) {
            return -1L;
        }
        if (this.curCollection.getClass().getName().equals("dragon.onlinedb.trec.TrecFileReader")) {
            return ((TrecFileReader)this.curCollection).getArticleOffset();
        }
        return ((TrecCollectionReader)this.curCollection).getArticleOffset();
    }

    public int getArticleLength() {
        if (this.curCollection == null) {
            return -1;
        }
        if (this.curCollection.getClass().getName().equals("dragon.onlinedb.trec.TrecFileReader")) {
            return ((TrecFileReader)this.curCollection).getArticleLength();
        }
        return ((TrecCollectionReader)this.curCollection).getArticleLength();
    }

    public String getArticleFilename() {
        if (this.curCollection == null) {
            return null;
        }
        String name = this.curCollection.getClass().getName().equals("dragon.onlinedb.trec.TrecFileReader") ? ((TrecFileReader)this.curCollection).getArticleFilename() : ((TrecCollectionReader)this.curCollection).getArticleFilename();
        if (this.filename == null) {
            return name;
        }
        return this.filename + "/" + name;
    }

    @Override
    public void close() {
        try {
            if (this.curCollection != null) {
                this.curCollection.close();
            }
            if (this.articleIndex != null) {
                this.articleIndex.close();
            }
            if (this.curCacheFileIndex >= 0) {
                this.curCacheFileIndex = -1;
                this.curCacheFile.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean supportArticleKeyRetrieval() {
        return this.articleIndex != null && !this.articleIndex.isWritingMode();
    }

    @Override
    public void restart() {
        this.loadCollection(this.collectionPath, this.indexFile);
    }

    @Override
    public int size() {
        return -1;
    }
}

