/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb.trec;

import dragon.onlinedb.trec.SgmArticleParser;
import dragon.util.Conversion;
import java.util.Date;

public class LATimesArticleParser
extends SgmArticleParser {
    @Override
    protected Date extractDate(String rawText) {
        try {
            String content = this.processParagraph(this.getTagContent(rawText, "DATE", false));
            int start = content.indexOf(",") + 1;
            start = content.indexOf(",", start);
            if (start < 0) {
                return null;
            }
            content = content.substring(0, start);
            return Conversion.engDate(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected String extractMeta(String rawText) {
        try {
            String content = this.processParagraph(this.getTagContent(rawText, "SECTION", false));
            int start = content.lastIndexOf(";");
            String last = content.substring(start + 1).trim();
            if (!last.endsWith("Desk")) {
                return null;
            }
            return last.substring(0, last.length() - 4).trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected int extractLength(String rawText) {
        try {
            String content = this.processParagraph(this.getTagContent(rawText, "LENGTH", false));
            if (content == null) {
                return -1;
            }
            int start = content.indexOf(" ");
            content = content.substring(0, start);
            return Integer.parseInt(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private String processParagraph(String paragraph) {
        if (paragraph == null) {
            return null;
        }
        int start = paragraph.indexOf("<P>");
        start = start < 0 ? 0 : (start += 3);
        int end = paragraph.indexOf("</P>", start);
        String content = end > 0 ? paragraph.substring(start, end) : paragraph.substring(start);
        content = content.replace('\r', ' ');
        content = content.replace('\n', ' ');
        return content.trim();
    }
}

