/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb.trec;

import dragon.onlinedb.Article;
import dragon.onlinedb.BasicArticle;
import dragon.onlinedb.trec.AbstractTopicReader;
import dragon.util.FileUtil;
import java.util.ArrayList;

public class EarlyTrecTopicReader
extends AbstractTopicReader {
    public EarlyTrecTopicReader(String topicFile) {
        super(topicFile);
    }

    @Override
    protected ArrayList loadTopics(String topicFile) {
        try {
            String content = FileUtil.readTextFile(topicFile);
            ArrayList<Article> list = new ArrayList<Article>();
            int start = 0;
            int end = content.indexOf("</top>");
            while (end > 0) {
                list.add(this.parseEarlyTrecTopic(content.substring(start, end += 6)));
                start = end;
                end = content.indexOf("</top>", start);
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Article parseEarlyTrecTopic(String content) {
        BasicArticle article = new BasicArticle();
        String section = this.getTopicSection("num", content);
        int start = section.indexOf(":") + 1;
        article.setKey(section.substring(start).trim());
        article.setCategory(Integer.parseInt(article.getKey()));
        section = this.getTopicSection("title", content);
        if (section != null) {
            start = section.indexOf(":") + 1;
            article.setTitle(section.substring(start).trim());
        }
        if ((section = this.getTopicSection("desc", content)) != null) {
            start = section.indexOf(":") + 1;
            article.setAbstract(section.substring(start).trim());
        }
        if ((section = this.getTopicSection("narr", content)) != null) {
            start = section.indexOf(":") + 1;
            article.setBody(section.substring(start).trim());
        }
        if ((section = this.getTopicSection("con", content)) != null) {
            start = section.indexOf(":") + 1;
            article.setMeta(section.substring(start).trim());
        }
        return article;
    }

    private String getTopicSection(String sectionName, String topic) {
        int start = topic.indexOf("<" + sectionName + ">");
        if (start < 0) {
            return null;
        }
        int end = topic.indexOf("\n<", start += sectionName.length() + 2);
        topic = topic.substring(start, end);
        return topic.replace('\n', ' ').trim();
    }
}

