/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb.trec;

import dragon.onlinedb.Article;
import dragon.onlinedb.ArticleParser;
import dragon.onlinedb.BasicArticleParser;
import dragon.onlinedb.CollectionReader;
import java.util.ArrayList;

public abstract class AbstractTopicReader
implements CollectionReader {
    private ArrayList topics;
    private int curTopic;

    public AbstractTopicReader(String topicFile) {
        this.topics = this.loadTopics(topicFile);
        this.curTopic = 0;
    }

    protected abstract ArrayList loadTopics(String var1);

    public boolean loadCollection(String topicFile) {
        this.topics = this.loadTopics(topicFile);
        this.curTopic = 0;
        return true;
    }

    @Override
    public ArticleParser getArticleParser() {
        return new BasicArticleParser();
    }

    @Override
    public void setArticleParser(ArticleParser parser) {
    }

    @Override
    public Article getNextArticle() {
        if (this.topics == null || this.curTopic >= this.topics.size()) {
            return null;
        }
        ++this.curTopic;
        return (Article)this.topics.get(this.curTopic - 1);
    }

    @Override
    public Article getArticleByKey(String key) {
        return null;
    }

    @Override
    public void close() {
        this.topics = null;
    }

    @Override
    public int size() {
        return this.topics.size();
    }

    @Override
    public boolean supportArticleKeyRetrieval() {
        return false;
    }

    @Override
    public void restart() {
        this.curTopic = 0;
    }
}

