/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb.searchengine;

public class WebLink
implements Comparable {
    private String url;
    private String host;
    private String path;
    private String summary;
    private String title;
    private int port;

    public WebLink(String url) {
        this.url = url;
        int start = url.indexOf("//");
        int end = url.indexOf("/", start + 2);
        this.host = url.substring(start + 2, end);
        this.path = url.substring(end);
        start = this.host.indexOf(":");
        if (start > 0) {
            this.port = Integer.parseInt(this.host.substring(start + 1));
            this.host = this.host.substring(0, start).trim();
        } else {
            this.port = 80;
        }
    }

    public WebLink(String host, String path) {
        this(host, 80, path, null);
    }

    public WebLink(String host, String path, String key) {
        this(host, 80, path, key);
    }

    public WebLink(String host, int port, String path, String key) {
        this.host = host;
        this.path = path;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public int getPort() {
        return this.port;
    }

    public int compareTo(Object obj) {
        int result = this.host.compareToIgnoreCase(((WebLink)obj).getHost());
        if (result != 0) {
            return result;
        }
        return this.path.compareToIgnoreCase(((WebLink)obj).getPath());
    }

    public String toString() {
        return this.url;
    }
}

