/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb.searchengine;

import dragon.onlinedb.searchengine.AbstractSearchEngine;
import dragon.onlinedb.searchengine.WebLink;
import dragon.util.HttpUtil;
import org.apache.commons.httpclient.util.URIUtil;

public class GoogleEngine
extends AbstractSearchEngine {
    private HttpUtil http = new HttpUtil("www.google.com", "UTF-8");

    public GoogleEngine() {
        super(10);
        this.http.setConnectionTimeout(10000);
        this.http.setSocketTimeout(10000);
    }

    @Override
    public void setSearchTerm(String term) {
        this.term = term;
    }

    @Override
    public boolean initQuery() {
        this.curPageNo = -1;
        this.curArticle = null;
        this.curPageWidth = 0;
        this.pageNum = 1;
        return true;
    }

    @Override
    public boolean moveToPage(int pageNo) {
        try {
            if (pageNo >= this.pageNum || this.pageNum == 0) {
                return false;
            }
            if (pageNo == this.curPageNo) {
                return true;
            }
            String query = this.term;
            query = query.replaceAll("  ", " ");
            query = query.replaceAll("  ", " ");
            query = query.replace(' ', '+');
            query = URIUtil.encodeAll((String)query, (String)"UTF-8");
            query = query.replaceAll("%2B", "+");
            int count = 0;
            while (pageNo < this.pageNum && count == 0) {
                String content;
                String url = pageNo == 0 ? "/search?hl=en&newwindow=1&rlz=1T4GZHY_enUS237US237&q=" + query + "&btnG=Search" : "/search?hl=en&newwindow=1&rlz=1T4GZHY_enUS237US237&q=" + query + "&start=" + pageNo * this.pageWidth;
                if (this.site != null && this.site.length() > 0) {
                    url = url + "&sitesearch=" + this.site;
                }
                if ((content = this.http.get(url, "UTF-8")) == null) {
                    return false;
                }
                count = this.processPage(pageNo, content);
                if (count < 0) {
                    return false;
                }
                if (count > 0) {
                    return true;
                }
                ++pageNo;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int processPage(int pageNo, String content) {
        try {
            int end;
            int count = 0;
            String word = this.getSummaryOnlyOption() ? ">Similar pages<" : ">Cached<";
            int startPos = content.indexOf(word);
            boolean hasDoc = startPos >= 0;
            while (startPos > 0) {
                int pos = startPos;
                int endPos = content.lastIndexOf("<span ", startPos - 5);
                String summary = content.substring(startPos = content.lastIndexOf("<table ", endPos), endPos);
                end = summary.indexOf("<span ");
                if (end >= 0) {
                    end = summary.indexOf("<br>", end + 5);
                    summary = summary.substring(end + 4);
                }
                if ((summary = this.parser.extractText(summary)) == null || summary.length() == 0) {
                    startPos = content.indexOf(word, pos + 10);
                    continue;
                }
                end = startPos;
                if (content.substring(startPos = content.lastIndexOf("href=", startPos - 5), end).indexOf("translate.google") >= 0) {
                    startPos = content.lastIndexOf("href=", startPos - 5);
                }
                endPos = content.indexOf("\"", startPos + 6);
                String url = content.substring(startPos + 6, endPos);
                startPos = content.indexOf(">", endPos);
                endPos = content.indexOf("</a>", startPos + 1);
                String title = this.parser.extractText(content.substring(startPos + 1, endPos));
                this.arrUrl[count] = new WebLink(url);
                this.arrUrl[count].setSummary(this.processSnippet(summary));
                this.arrUrl[count].setTitle(this.processSnippet(title));
                ++count;
                startPos = content.indexOf(word, pos + 10);
            }
            this.curPageNo = pageNo;
            this.curPageWidth = count;
            this.curArticleNo = 0;
            if (this.curPageWidth == 0 && !hasDoc) {
                return -1;
            }
            if (count > 0) {
                this.curArticle = this.getArticle(0);
            }
            if ((end = content.indexOf(">Next<")) >= 0) {
                this.pageNum = pageNo + 2;
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private String processSnippet(String content) {
        if (content == null || content.length() == 0) {
            return content;
        }
        content = content.replaceAll("&#39;", "'");
        content = content.replaceAll("&quot;", "\"");
        content = content.replaceAll("&lt;", "<");
        content = content.replaceAll("&gt;", ">");
        return content;
    }
}

