/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb.searchengine;

import dragon.onlinedb.AbstractQuery;
import dragon.onlinedb.Article;
import dragon.onlinedb.BasicArticle;
import dragon.onlinedb.searchengine.WebLink;
import dragon.util.HttpContent;
import dragon.util.HttpUtil;

public abstract class AbstractSearchEngine
extends AbstractQuery {
    private HttpUtil webServer;
    protected WebLink[] arrUrl;
    protected String term;
    protected HttpContent parser;
    protected String site;
    protected String defaultEncoding;
    private boolean summaryOnly;
    private boolean removeTag;

    public AbstractSearchEngine(int pageWidth) {
        super(pageWidth);
        this.arrUrl = new WebLink[this.pageWidth];
        this.removeTag = true;
        this.parser = new HttpContent();
        this.webServer = new HttpUtil("www.google.com");
        this.webServer.setConnectionTimeout(10000);
        this.webServer.setSocketTimeout(10000);
        this.site = null;
        this.defaultEncoding = null;
        this.summaryOnly = false;
    }

    public void setSiteRestriction(String site) {
        if (site != null) {
            site = site.trim();
        }
        this.site = site;
    }

    public String getSiteRestriction() {
        return this.site;
    }

    public void setDefaultEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setAutoRefresh(boolean enable) {
        this.webServer.setAutoRefresh(enable);
    }

    public boolean getAutoRefresh() {
        return this.webServer.getAutoRefresh();
    }

    public void setSummaryOnlyOption(boolean option) {
        this.summaryOnly = option;
    }

    public boolean getSummaryOnlyOption() {
        return this.summaryOnly;
    }

    public void setRemoveTagOption(boolean option) {
        this.removeTag = option;
    }

    public boolean getRemoveTagOption() {
        return this.removeTag;
    }

    @Override
    public void setSearchTerm(String term) {
        this.term = term;
    }

    @Override
    public boolean supportArticleKeyRetrieval() {
        return true;
    }

    @Override
    public Article getArticleByKey(String id) {
        WebLink link = new WebLink(id);
        return this.getArticle(link, true);
    }

    @Override
    protected Article getArticle(int articleNo) {
        return this.getArticle(this.arrUrl[articleNo], false);
    }

    protected Article getArticle(WebLink link, boolean useKey) {
        BasicArticle article = new BasicArticle();
        article.setKey(link.toString());
        article.setTitle(link.getTitle());
        if (this.summaryOnly && !useKey) {
            article.setBody(link.getSummary());
            return article;
        }
        try {
            String content;
            if (!this.webServer.getHost().equalsIgnoreCase(link.getHost()) || this.webServer.getPort() != link.getPort()) {
                this.webServer.setHost(link.getHost(), link.getPort(), this.defaultEncoding);
            }
            if ((content = this.webServer.get(link.getPath())) == null) {
                return article;
            }
            int start = content.indexOf("<html");
            if (start < 0) {
                start = content.indexOf("<HTML");
            }
            if (start < 0) {
                return article;
            }
            if (this.removeTag) {
                if ((start = content.indexOf("<title>", start)) < 0) {
                    start = content.indexOf("<TITLE>");
                }
                if (start >= 0) {
                    int end = content.indexOf("<", start += 7);
                    article.setTitle(content.substring(start, end));
                } else {
                    start = 0;
                }
                start = content.indexOf("<body ", start);
                if (start < 0) {
                    start = content.indexOf("<BODY ");
                }
                if (start > 0) {
                    content = content.substring(start);
                }
                article.setBody(this.parser.extractText(content));
            } else {
                article.setBody(content);
            }
            return article;
        }
        catch (Exception e) {
            return article;
        }
    }

    public static void sleepOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void sleepManySeconds(long s) {
        try {
            Thread.sleep(s * 1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

