/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb.citeulike;

import dragon.onlinedb.AbstractQuery;
import dragon.onlinedb.Article;
import dragon.onlinedb.ArticleParser;
import dragon.onlinedb.citeulike.CiteULikeArticleParser;
import dragon.util.HttpUtil;

public class CiteULikeTagQuery
extends AbstractQuery {
    protected HttpUtil http;
    protected String term;
    protected String[] arrPaper;
    private ArticleParser parser = new CiteULikeArticleParser();

    public static void main(String[] args) {
        CiteULikeTagQuery query = new CiteULikeTagQuery("network");
        query.initQuery();
        int top = 10;
        for (int i = 0; i < top && query.moveToNextArticle(); ++i) {
            Article article = query.getArticle();
            System.out.println(query.getArticle().getKey() + " " + article.getTitle());
        }
    }

    public CiteULikeTagQuery() {
        this(null);
    }

    public CiteULikeTagQuery(String term) {
        super(50);
        this.arrPaper = new String[this.pageWidth];
        this.term = term;
        this.http = new HttpUtil("www.citeulike.org");
    }

    @Override
    public boolean supportArticleKeyRetrieval() {
        return true;
    }

    @Override
    public void setSearchTerm(String term) {
        this.term = term;
    }

    @Override
    public boolean initQuery() {
        this.curPageNo = -1;
        this.curArticle = null;
        this.curPageWidth = 0;
        this.pageNum = 1;
        return true;
    }

    @Override
    public boolean moveToPage(int pageNo) {
        String content;
        if (pageNo >= this.pageNum || this.pageNum == 0) {
            return false;
        }
        if (pageNo == this.curPageNo) {
            return true;
        }
        String curUrl = "/search/all?f=tag&q=" + this.term;
        if (pageNo > 0) {
            curUrl = curUrl + "&page=" + (pageNo + 1);
        }
        if ((content = this.http.get(curUrl)) == null) {
            return false;
        }
        return this.processPage(pageNo, content);
    }

    private boolean processPage(int pageNo, String content) {
        int end;
        int count = 0;
        int start = content.indexOf("class=\"title\"");
        while (start >= 0 && (start = content.indexOf("article", start)) >= 0) {
            end = content.indexOf(34, start += 8);
            this.arrPaper[count] = content.substring(start, end);
            ++count;
            start = content.indexOf("class=\"title\"", end);
        }
        this.curPageNo = pageNo;
        this.curPageWidth = count;
        this.curArticleNo = 0;
        if (this.curPageWidth == 0) {
            return false;
        }
        this.curArticle = this.getArticleByKey(this.arrPaper[this.curArticleNo]);
        end = content.indexOf(">Next<");
        if (end < 0) {
            this.pageNum = pageNo + 1;
        } else {
            end = content.lastIndexOf("</a>", end);
            start = content.lastIndexOf(62, end);
            this.pageNum = Integer.parseInt(content.substring(start + 1, end));
        }
        return true;
    }

    @Override
    public Article getArticleByKey(String id) {
        try {
            String curUrl = "/article/" + id;
            String content = this.http.get(curUrl);
            if (content == null) {
                return null;
            }
            return this.parser.parse(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected Article getArticle(int articleNo) {
        return this.getArticleByKey(this.arrPaper[articleNo]);
    }
}

