/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb.amazon;

import dragon.onlinedb.AbstractQuery;
import dragon.onlinedb.Article;
import dragon.onlinedb.BasicArticle;
import dragon.util.Conversion;
import dragon.util.HttpUtil;

public class AmazonReviewQuery
extends AbstractQuery {
    protected String webEnv;
    protected String queryKey;
    protected String term;
    protected String reviewUrl;
    protected Article[] arrArticle;
    protected HttpUtil http;

    public AmazonReviewQuery(String productCode) {
        super(10);
        this.arrArticle = new Article[this.pageWidth];
        this.term = productCode;
        this.reviewUrl = "/gp/product/customer-reviews/";
        this.http = new HttpUtil("www.amazon.com");
    }

    public AmazonReviewQuery() {
        super(10);
        this.arrArticle = new Article[this.pageWidth];
        this.reviewUrl = "/gp/product/customer-reviews/";
        this.http = new HttpUtil("www.amazon.com");
    }

    public static void main(String[] args) {
        AmazonReviewQuery query = new AmazonReviewQuery("B000AYGDIO");
        query.initQuery();
    }

    @Override
    public boolean supportArticleKeyRetrieval() {
        return false;
    }

    @Override
    public void setSearchTerm(String productCode) {
        this.term = productCode;
    }

    @Override
    public boolean initQuery() {
        this.curPageNo = -1;
        this.curArticle = null;
        this.curPageWidth = 0;
        String curUrl = this.reviewUrl + this.term;
        String content = this.http.get(curUrl);
        if (content == null) {
            return false;
        }
        this.articleNum = this.getReviewNum(content);
        this.pageNum = this.articleNum == 0 ? 0 : (this.articleNum - 1) / this.pageWidth + 1;
        if (this.articleNum > 0) {
            this.curPageWidth = this.readReviewsFromWebPage(content);
        }
        return true;
    }

    @Override
    public boolean moveToPage(int pageNo) {
        if (pageNo >= this.pageNum || this.pageNum == 0) {
            return false;
        }
        if (pageNo == this.curPageNo) {
            return true;
        }
        if (pageNo == 0 && this.curPageNo == -1) {
            this.curPageNo = pageNo;
            this.curArticleNo = 0;
            if (this.curPageWidth <= 0) {
                return false;
            }
            this.curArticle = this.arrArticle[this.curArticleNo];
            return true;
        }
        String curUrl = this.reviewUrl + this.term + "?_encoding=UTF8&customer-reviews.sort_by=-SubmissionDate&customer-reviews.start=" + (pageNo * this.pageWidth + 1);
        String content = this.http.get(curUrl);
        if (content == null) {
            return false;
        }
        this.curPageWidth = this.readReviewsFromWebPage(content);
        if (this.curPageWidth <= 0) {
            return false;
        }
        this.curPageNo = pageNo;
        this.curArticleNo = 0;
        this.curArticle = this.arrArticle[this.curArticleNo];
        return true;
    }

    @Override
    public Article getArticleByKey(String PMID) {
        return null;
    }

    @Override
    protected Article getArticle(int articleNo) {
        return this.arrArticle[articleNo];
    }

    private int getReviewNum(String content) {
        try {
            int start = content.indexOf("customer-reviews.sort_by");
            if (start < 0) {
                return 0;
            }
            if ((start = content.indexOf("</form>", start)) < 0) {
                return 0;
            }
            int end = start + 7;
            while (!Character.isDigit(content.charAt(end))) {
                ++end;
            }
            if (end - start >= 30) {
                return 0;
            }
            start = content.indexOf("of ", end) + 3;
            end = content.indexOf("\n", start);
            return Integer.parseInt(content.substring(start, end));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int readReviewsFromWebPage(String content) {
        try {
            int start = content.indexOf("customer-reviews.sort_by");
            if (start < 0) {
                return 0;
            }
            if ((start = content.indexOf("</form>", start)) < 0) {
                return 0;
            }
            int count = 0;
            start = content.indexOf("<!-- BOUNDARY -->", start);
            while (start > 0) {
                int end = content.indexOf("<!-- BOUNDARY -->", start + 20);
                if (end > 0) {
                    this.arrArticle[count] = this.readReview(content.substring(start, end));
                    ++count;
                    start = end;
                    continue;
                }
                end = content.indexOf("<hr ", start);
                this.arrArticle[count] = this.readReview(content.substring(start, end));
                ++count;
                start = -1;
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private Article readReview(String content) {
        BasicArticle article = new BasicArticle();
        int start = content.indexOf("name=\"") + 7;
        int end = content.indexOf("\"", start);
        article.setKey(content.substring(start, end));
        end = content.indexOf("width", end);
        start = content.lastIndexOf("/", end);
        article.setCategory(Integer.parseInt(content.substring(start + 7, start + 8)));
        start = content.indexOf("<b>", end) + 3;
        end = content.indexOf("</b>", start);
        article.setTitle(content.substring(start, end));
        start = end + 5;
        end = content.indexOf("<br />", start);
        article.setDate(Conversion.engDate(content.substring(start, end).trim()));
        start = content.indexOf("</b>", end);
        start = start > 0 ? (start += 4) : content.indexOf("</table>", end) + 8;
        end = content.indexOf("<nobr>", start);
        end = content.lastIndexOf("<br /><br />", end);
        article.setAbstract(this.processReviewContent(content.substring(start, end)));
        return article;
    }

    private String processReviewContent(String raw) {
        raw = raw.replaceAll("\r", "");
        raw = raw.replaceAll("\n", "");
        raw = raw.replaceAll("<br />", "<br>");
        raw = raw.replaceAll("<p>", "<br>");
        String[] arrPara = raw.split("<br>");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arrPara.length; ++i) {
            String line;
            if (arrPara[i] == null || (line = arrPara[i].trim()).length() == 0) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(line);
            if (".?!".indexOf(line.charAt(line.length() - 1)) >= 0) continue;
            sb.append('.');
        }
        return sb.toString();
    }
}

