/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb.amazon;

import dragon.onlinedb.AbstractQuery;
import dragon.onlinedb.Article;
import dragon.onlinedb.BasicArticle;
import dragon.util.FileUtil;
import dragon.util.HttpUtil;
import dragon.util.SortedArray;
import java.io.BufferedWriter;

public class AmazonCatalogQuery
extends AbstractQuery {
    protected String queryKey;
    protected String term;
    protected String searchUrl;
    protected String browseUrl;
    protected Article[] arrArticle;
    protected HttpUtil http;

    public AmazonCatalogQuery(String productCatalog) {
        super(24);
        this.arrArticle = new Article[this.pageWidth];
        this.term = productCatalog;
        this.searchUrl = "/gp/search";
        this.browseUrl = "/gp/browse.html";
        this.http = new HttpUtil("www.amazon.com");
    }

    public AmazonCatalogQuery() {
        super(24);
        this.arrArticle = new Article[this.pageWidth];
        this.searchUrl = "/gp/search";
        this.browseUrl = "/gp/browse.html";
        this.http = new HttpUtil("www.amazon.com");
    }

    public static void main(String[] args) {
        AmazonCatalogQuery.getProductList("565108", "indexreview/laptop.query", "indexreview/laptop.desc");
    }

    public static void getProductList(String catalogNode, String codeListFile, String descriptionListFile) {
        try {
            AmazonCatalogQuery query = new AmazonCatalogQuery(catalogNode);
            if (!query.initQuery() || query.size() <= 0) {
                return;
            }
            int count = 0;
            SortedArray codeList = new SortedArray(query.size());
            BufferedWriter bwDesc = FileUtil.getTextWriter(descriptionListFile);
            while (query.moveToNextArticle()) {
                Article article = query.getArticle();
                if (article.getKey() == null) continue;
                System.out.println(count + " " + article.getKey());
                bwDesc.write(article.getKey() + "\t" + article.getTitle() + "\n");
                bwDesc.flush();
                codeList.add(article.getKey() + "");
                ++count;
            }
            bwDesc.close();
            BufferedWriter bwCode = FileUtil.getTextWriter(codeListFile);
            bwCode.write(codeList.size() + "\n");
            for (int i = 0; i < codeList.size(); ++i) {
                bwCode.write((String)codeList.get(i) + "\n");
                bwCode.flush();
            }
            bwCode.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean supportArticleKeyRetrieval() {
        return false;
    }

    @Override
    public void setSearchTerm(String productCatalog) {
        this.term = productCatalog;
    }

    @Override
    public boolean initQuery() {
        this.curPageNo = -1;
        this.curArticle = null;
        this.curPageWidth = 0;
        String curUrl = this.browseUrl + "?_encoding=UTF8&node=" + this.term;
        String content = this.http.get(curUrl);
        if (content == null) {
            return false;
        }
        this.articleNum = this.getProductNum(content);
        this.pageNum = this.articleNum == 0 ? 0 : (this.articleNum - 1) / this.pageWidth + 1;
        if (this.articleNum > 0) {
            this.curPageWidth = this.readProductFromWebPage(content);
        }
        return true;
    }

    @Override
    public boolean moveToPage(int pageNo) {
        if (pageNo >= this.pageNum || this.pageNum == 0) {
            return false;
        }
        if (pageNo == 0 && this.curPageNo == -1) {
            this.curPageNo = pageNo;
            this.curArticleNo = 0;
            if (this.curPageWidth <= 0) {
                return false;
            }
            this.curArticle = this.arrArticle[this.curArticleNo];
            return true;
        }
        String curUrl = this.searchUrl + "?_encoding=UTF8&rh=" + this.queryKey + "&page=" + (pageNo + 1);
        String content = this.http.get(curUrl);
        if (content == null) {
            return false;
        }
        this.curPageWidth = this.readProductFromWebPage(content);
        if (this.curPageWidth <= 0) {
            return false;
        }
        this.curPageNo = pageNo;
        this.curArticleNo = 0;
        this.curArticle = this.arrArticle[this.curArticleNo];
        return true;
    }

    @Override
    public Article getArticleByKey(String PMID) {
        return null;
    }

    @Override
    protected Article getArticle(int articleNo) {
        return this.arrArticle[articleNo];
    }

    private int getProductNum(String content) {
        try {
            int start = content.indexOf("\"ladderCount\"");
            if (start < 0) {
                return 0;
            }
            start = content.indexOf("of ", start) + 3;
            int end = content.indexOf(" result", start);
            int num = Integer.parseInt(content.substring(start, end));
            start = content.indexOf("name=\"rh\"", end) + 9;
            start = content.indexOf("\"", start) + 1;
            end = content.indexOf("\"", start);
            this.queryKey = content.substring(start, end);
            return num;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int readProductFromWebPage(String content) {
        try {
            int start = content.indexOf("<div id=\"Results\">");
            if (start < 0) {
                return 0;
            }
            int end = content.indexOf("</div>", start);
            if (start < 0) {
                return 0;
            }
            content = content.substring(start, end);
            int count = 0;
            start = content.indexOf("id=\"Td:");
            while (start > 0) {
                end = content.indexOf("id=\"Td:", start + 10);
                if (end > 0) {
                    this.arrArticle[count] = this.readProduct(content.substring(start, end));
                    ++count;
                    start = end;
                } else {
                    this.arrArticle[count] = this.readProduct(content.substring(start));
                    ++count;
                    start = end;
                }
                if (this.arrArticle[count - 1] != null) continue;
                return 0;
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private Article readProduct(String content) {
        int end;
        String key;
        BasicArticle article = new BasicArticle();
        int start = content.indexOf("<a ") + 3;
        start = content.indexOf("<a ", start);
        if ((start = content.indexOf("product/", start)) < 0) {
            return article;
        }
        if ((key = content.substring(start += 8, end = content.indexOf("/", start)).trim()).length() > 10) {
            return null;
        }
        article.setKey(content.substring(start, end));
        start = content.indexOf(">", end) + 1;
        end = content.indexOf("<", start);
        article.setTitle(content.substring(start, end));
        return article;
    }
}

