/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb;

import dragon.onlinedb.Article;
import dragon.onlinedb.ArticleQuery;
import dragon.onlinedb.BasicCollectionWriter;
import dragon.onlinedb.CollectionPreparer;
import dragon.onlinedb.CollectionWriter;
import dragon.onlinedb.amazon.AmazonReviewQuery;
import dragon.util.FileUtil;
import java.io.BufferedReader;
import java.util.Date;

public class BasicCollectionPreparer
implements CollectionPreparer {
    private CollectionWriter collectionWriter;
    private ArticleQuery query;

    public static void main(String[] args) {
        BasicCollectionWriter writer = new BasicCollectionWriter("indexreview/dc/dc.collection", "indexreview/dc/dc.index", false);
        AmazonReviewQuery query = new AmazonReviewQuery();
        BasicCollectionPreparer preparer = new BasicCollectionPreparer(writer, query);
        preparer.addArticles("indexreview/dc/dc.query");
        preparer.close();
    }

    public BasicCollectionPreparer(CollectionWriter writer, ArticleQuery query) {
        this.collectionWriter = writer;
        this.query = query;
    }

    @Override
    public boolean addListedArticles(String articleKeyFile) {
        try {
            String line;
            if (!this.query.supportArticleKeyRetrieval()) {
                return false;
            }
            BufferedReader br = FileUtil.getTextReader(articleKeyFile);
            while ((line = br.readLine()) != null) {
                System.out.println(new Date().toString() + " Processing article #" + line);
                Article article = this.query.getArticleByKey(line);
                if (article == null) continue;
                this.collectionWriter.add(article);
            }
            br.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean addArticles(ArticleQuery query) {
        try {
            while (query.moveToNextArticle()) {
                Article article = query.getArticle();
                if (article == null) continue;
                System.out.println("Processing article #" + article.getKey());
                this.collectionWriter.add(article);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean addArticles(String queryFile) {
        String[] arrQuery = this.loadQuery(queryFile);
        if (arrQuery == null) {
            return false;
        }
        return this.addArticles(arrQuery);
    }

    @Override
    public boolean addArticles(String[] queries) {
        try {
            for (int i = 0; i < queries.length; ++i) {
                System.out.print(new Date().toString() + " Initializing Query: " + queries[i]);
                this.query.setSearchTerm(queries[i]);
                if (!this.query.initQuery()) {
                    System.out.println("  0");
                    return false;
                }
                System.out.println("  " + this.query.size());
                this.addArticles(this.query);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean addArticles(ArticleQuery query, int interval) {
        try {
            int i = -1;
            while (query.moveToNextArticle()) {
                Article article;
                if (++i % interval != 0 || (article = query.getArticle()) == null) continue;
                System.out.println("Processing article #" + article.getKey());
                this.collectionWriter.add(article);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void close() {
        this.collectionWriter.close();
    }

    private String[] loadQuery(String queryFile) {
        try {
            BufferedReader br = FileUtil.getTextReader(queryFile);
            int queryNum = Integer.parseInt(br.readLine());
            String[] queries = new String[queryNum];
            for (int i = 0; i < queryNum; ++i) {
                queries[i] = br.readLine();
            }
            return queries;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

