/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb;

import dragon.onlinedb.Article;
import dragon.onlinedb.ArticleParser;
import dragon.onlinedb.BasicArticle;

public class BasicArticleParser
implements ArticleParser {
    @Override
    public Article parse(String line) {
        try {
            if (line == null || line.trim().length() == 0) {
                return null;
            }
            String[] arrField = line.split("\t");
            BasicArticle cur = new BasicArticle();
            cur.setKey(arrField[0]);
            if (arrField.length >= 2) {
                cur.setTitle(arrField[1]);
            }
            if (arrField.length >= 3) {
                cur.setMeta(arrField[2]);
            }
            if (arrField.length >= 4) {
                cur.setAbstract(arrField[3]);
            }
            if (arrField.length >= 5) {
                cur.setBody(arrField[4]);
            }
            if (arrField.length >= 6) {
                cur.setCategory(Integer.parseInt(arrField[5]));
            } else {
                cur.setCategory(-1);
            }
            return cur;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String assemble(Article article) {
        try {
            StringBuffer sb = new StringBuffer(10240);
            sb.append(article.getKey());
            sb.append('\t');
            if (article.getTitle() != null) {
                sb.append(this.processText(article.getTitle()));
            }
            sb.append('\t');
            if (article.getMeta() != null) {
                sb.append(this.processText(article.getMeta()));
            }
            sb.append('\t');
            if (article.getAbstract() != null) {
                sb.append(this.processText(article.getAbstract()));
            }
            sb.append('\t');
            if (article.getBody() != null) {
                sb.append(this.processText(article.getBody()));
            }
            if (article.getCategory() >= 0) {
                sb.append('\t');
                sb.append(article.getCategory());
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String processText(String text) {
        text = text.replace('\t', ' ');
        text = text.replace('\r', ' ');
        return text.replace('\n', ' ');
    }
}

