/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb;

import dragon.nlp.SimpleElement;
import dragon.nlp.SimpleElementList;
import dragon.onlinedb.BasicArticleKey;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;

public class BasicArticleIndex {
    private long collectionSize;
    private SortedArray list;
    private SimpleElementList fileList;
    private boolean writingMode;
    private String indexFilename;

    public BasicArticleIndex(String indexFilename, boolean writingMode) {
        this.writingMode = writingMode;
        this.indexFilename = indexFilename;
        this.loadKeyList(indexFilename);
    }

    public boolean isWritingMode() {
        return this.writingMode;
    }

    public boolean add(String key, long offset) {
        if (!this.writingMode) {
            return false;
        }
        BasicArticleKey basicKey = new BasicArticleKey(new String(key));
        basicKey.setOffset(offset);
        return this.list.add(basicKey);
    }

    public boolean add(String key, String filename, long offset, int length) {
        if (!this.writingMode) {
            return false;
        }
        BasicArticleKey basicKey = new BasicArticleKey(new String(key));
        basicKey.setOffset(offset);
        basicKey.setFileIndex(this.fileList.add(filename));
        basicKey.setLength(length);
        return this.list.add(basicKey);
    }

    public String getFilename(int fileIndex) {
        return this.fileList.search(fileIndex);
    }

    public boolean contains(String key) {
        return this.list.contains(new BasicArticleKey(key));
    }

    public BasicArticleKey search(String key) {
        int pos = this.list.binarySearch(new BasicArticleKey(key));
        if (pos >= 0) {
            return (BasicArticleKey)this.list.get(pos);
        }
        return null;
    }

    public void setCollectionFileSize(long size) {
        this.collectionSize = size;
    }

    public long getCollectionFileSize() {
        return this.collectionSize;
    }

    public void close() {
        if (this.writingMode) {
            this.saveKeyList(this.indexFilename, this.list, this.fileList);
        }
        this.list.clear();
    }

    private void loadKeyList(String indexFilename) {
        try {
            String line;
            File file = new File(indexFilename);
            if (!file.exists()) {
                this.list = new SortedArray();
                this.fileList = new SimpleElementList();
                return;
            }
            BufferedReader br = FileUtil.getTextReader(file);
            String[] arrField = br.readLine().split("\t");
            int total = Integer.parseInt(arrField[0]);
            this.list = new SortedArray(total);
            this.collectionSize = Long.parseLong(arrField[1]);
            this.fileList = new SimpleElementList();
            for (int i = 0; i < total; ++i) {
                line = br.readLine();
                arrField = line.split("\t");
                BasicArticleKey cur = new BasicArticleKey(arrField[0]);
                cur.setOffset(Long.parseLong(arrField[1]));
                if (arrField.length >= 4) {
                    cur.setLength(Integer.parseInt(arrField[2]));
                    cur.setFileIndex(Integer.parseInt(arrField[3]));
                }
                this.list.add(cur);
            }
            while ((line = br.readLine()) != null) {
                arrField = line.split("\t");
                this.fileList.add(new SimpleElement(arrField[0], Integer.parseInt(arrField[1])));
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveKeyList(String docKeyListFilename, SortedArray list, SimpleElementList fileList) {
        try {
            int i;
            if (list == null) {
                return;
            }
            BufferedWriter bw = FileUtil.getTextWriter(docKeyListFilename);
            bw.write(list.size() + "\t" + this.collectionSize + "\t" + fileList.size() + "\n");
            for (i = 0; i < list.size(); ++i) {
                BasicArticleKey cur = (BasicArticleKey)list.get(i);
                bw.write(cur.getKey() + "\t" + cur.getOffset());
                if (cur.getLength() > 0) {
                    bw.write("\t" + cur.getLength() + "\t" + cur.getFileIndex());
                }
                bw.write("\n");
                bw.flush();
            }
            for (i = 0; i < fileList.size(); ++i) {
                bw.write(fileList.search(i) + "\t" + i + "\n");
                bw.flush();
            }
            bw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

