/*
 * Decompiled with CFR 0.152.
 */
package dragon.onlinedb;

import dragon.onlinedb.Article;
import dragon.onlinedb.ArticleParser;
import dragon.onlinedb.ArticleQuery;

public abstract class AbstractQuery
implements ArticleQuery {
    protected int curPageNo;
    protected int curArticleNo;
    protected int pageNum;
    protected int articleNum;
    protected int pageWidth;
    protected int curPageWidth;
    protected Article curArticle;
    protected ArticleParser parser;

    protected abstract Article getArticle(int var1);

    public AbstractQuery(int pageWidth) {
        this.pageWidth = pageWidth;
        this.curPageNo = -1;
        this.curArticle = null;
        this.articleNum = -1;
    }

    @Override
    public int getCurPageNo() {
        return this.curPageNo;
    }

    @Override
    public boolean moveToNextPage() {
        return this.moveToPage(this.curPageNo + 1);
    }

    public int getTotalArticleNum() {
        return this.articleNum;
    }

    @Override
    public int getPageNum() {
        return this.pageNum;
    }

    @Override
    public int getPageWidth() {
        return this.pageWidth;
    }

    @Override
    public int getCurPageWidth() {
        return this.curPageWidth;
    }

    @Override
    public boolean moveToNextArticle() {
        if (this.curArticleNo >= this.curPageWidth - 1 || this.curPageNo < 0) {
            if (!this.moveToNextPage()) {
                return false;
            }
        } else {
            ++this.curArticleNo;
            this.curArticle = this.getArticle(this.curArticleNo);
        }
        return true;
    }

    @Override
    public boolean moveToArticle(int paperNo) {
        if (paperNo < 0 || paperNo > this.curPageWidth) {
            return false;
        }
        this.curArticleNo = paperNo;
        this.curArticle = this.getArticle(this.curArticleNo);
        return true;
    }

    @Override
    public Article getArticle() {
        return this.curArticle;
    }

    @Override
    public String getArticleKey() {
        return this.curArticle.getKey();
    }

    public boolean loadCollection(String collectionPath, String collectionName) {
        return false;
    }

    @Override
    public ArticleParser getArticleParser() {
        return this.parser;
    }

    @Override
    public void setArticleParser(ArticleParser parser) {
        this.parser = parser;
    }

    @Override
    public Article getNextArticle() {
        if (this.moveToNextArticle()) {
            return this.curArticle;
        }
        return null;
    }

    @Override
    public void close() {
        this.curPageNo = -1;
        this.curArticle = null;
    }

    @Override
    public void restart() {
        this.close();
        this.initQuery();
    }

    @Override
    public int size() {
        return this.articleNum;
    }
}

