/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool.xtract;

import dragon.nlp.compare.IndexComparator;
import dragon.nlp.tool.xtract.WordPairStat;
import dragon.util.ByteArrayConvert;
import dragon.util.FastBinaryReader;
import dragon.util.SortedArray;
import java.io.RandomAccessFile;
import java.util.Date;

public class WordPairStatList {
    private RandomAccessFile raf;
    private SortedArray indexList;
    private int maxSpan;
    private int elementLength;
    private boolean writingMode;
    private String indexlistFilename;
    private int pairNum;
    private int maxOldIndex;
    private int maxIndex;
    private int maxCacheSize;
    private byte[] buf;

    public WordPairStatList(String filename, int maxSpan, boolean writingMode) {
        try {
            this.maxSpan = maxSpan;
            this.elementLength = 4 * (2 * maxSpan + 3);
            this.buf = new byte[this.elementLength];
            this.writingMode = writingMode;
            this.indexlistFilename = filename;
            this.maxCacheSize = 200000;
            if (writingMode) {
                this.raf = new RandomAccessFile(filename, "rw");
                if (this.raf.length() < 4L) {
                    this.raf.writeInt(0);
                    this.maxOldIndex = -1;
                } else {
                    this.maxOldIndex = this.raf.readInt() - 1;
                }
                this.maxIndex = this.maxOldIndex;
                this.raf.close();
                this.raf = null;
                this.indexList = new SortedArray(new IndexComparator());
            } else {
                this.raf = new RandomAccessFile(filename, "r");
                this.pairNum = this.raf.length() > 0L ? this.raf.readInt() : 0;
                this.maxIndex = this.pairNum - 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCacheSize(int size) {
        this.maxCacheSize = size;
    }

    public int getCacheSize() {
        return this.maxCacheSize;
    }

    public WordPairStat get(int index) {
        try {
            if (this.writingMode || index >= this.pairNum) {
                return null;
            }
            this.raf.seek(index * this.elementLength + 4);
            this.raf.read(this.buf);
            return this.getWordPairStatFromByteArray(this.buf);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean add(WordPairStat stat) {
        if (!this.writingMode) {
            return false;
        }
        if (!this.indexList.add(stat)) {
            int i;
            WordPairStat oldStat = (WordPairStat)this.indexList.get(this.indexList.insertedPos());
            for (i = 1; i <= this.maxSpan; ++i) {
                oldStat.addFrequency(i, stat.getFrequency(i));
            }
            for (i = 1; i <= this.maxSpan; ++i) {
                oldStat.addFrequency(-i, stat.getFrequency(-i));
            }
        } else {
            if (stat.getIndex() > this.maxIndex) {
                this.maxIndex = stat.getIndex();
            }
            if (this.indexList.size() > this.maxCacheSize) {
                this.saveIndexList(this.indexlistFilename, this.indexList);
            }
        }
        return true;
    }

    public int size() {
        return this.maxIndex + 1;
    }

    public void close() {
        try {
            if (this.writingMode) {
                this.saveIndexList(this.indexlistFilename, this.indexList);
                this.indexList.clear();
            } else {
                this.raf.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveIndexList(String filename, SortedArray list) {
        try {
            int j;
            WordPairStat cur;
            int i;
            if (list == null || list.size() == 0) {
                return;
            }
            System.out.println(new Date() + " Saving Word Pair List...");
            FastBinaryReader fbr = new FastBinaryReader(filename);
            fbr.skip(4L);
            int lastIndex = 0;
            for (i = 0; i < list.size() && (cur = (WordPairStat)list.get(i)).getIndex() <= this.maxOldIndex; ++i) {
                fbr.skip((cur.getIndex() - lastIndex) * this.elementLength + 12);
                for (j = 0; j < this.maxSpan; ++j) {
                    cur.addFrequency(j - this.maxSpan, fbr.readInt());
                }
                for (j = 1; j <= this.maxSpan; ++j) {
                    cur.addFrequency(j, fbr.readInt());
                }
                lastIndex = cur.getIndex() + 1;
            }
            int cutoff = i - 1;
            fbr.close();
            RandomAccessFile rafPair = new RandomAccessFile(filename, "rw");
            rafPair.writeInt(this.maxIndex + 1);
            for (i = 0; i <= cutoff; ++i) {
                cur = (WordPairStat)list.get(i);
                rafPair.seek(cur.getIndex() * this.elementLength + 4);
                this.writeToByteArray(cur, this.buf);
                rafPair.write(this.buf);
            }
            lastIndex = this.maxOldIndex;
            rafPair.seek((this.maxOldIndex + 1) * this.elementLength + 4);
            for (i = cutoff + 1; i < list.size(); ++i) {
                cur = (WordPairStat)list.get(i);
                for (j = lastIndex + 1; j < cur.getIndex(); ++j) {
                    this.writeToByteArray(j, this.buf);
                    rafPair.write(this.buf);
                }
                this.writeToByteArray(cur, this.buf);
                rafPair.write(this.buf);
                lastIndex = cur.getIndex();
            }
            rafPair.close();
            this.maxOldIndex = this.maxIndex;
            list.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void writeToByteArray(WordPairStat cur, byte[] array) {
        int i;
        ByteArrayConvert.toByte(cur.getIndex(), array, 0);
        ByteArrayConvert.toByte(cur.getFirstWord(), array, 4);
        ByteArrayConvert.toByte(cur.getSecondWord(), array, 8);
        for (i = 0; i < this.maxSpan; ++i) {
            ByteArrayConvert.toByte(cur.getFrequency(i - this.maxSpan), array, i * 4 + 12);
        }
        for (i = 0; i < this.maxSpan; ++i) {
            ByteArrayConvert.toByte(cur.getFrequency(i + 1), array, (i + this.maxSpan) * 4 + 12);
        }
    }

    private void writeToByteArray(int index, byte[] array) {
        ByteArrayConvert.toByte(index, array, 0);
        ByteArrayConvert.toByte(-1, array, 4);
        ByteArrayConvert.toByte(-1, array, 8);
        for (int i = 0; i < 2 * this.maxSpan; ++i) {
            ByteArrayConvert.toByte(0, array, i * 4 + 12);
        }
    }

    private WordPairStat getWordPairStatFromByteArray(byte[] array) {
        int i;
        WordPairStat cur = new WordPairStat(ByteArrayConvert.toInt(array, 0), ByteArrayConvert.toInt(array, 4), ByteArrayConvert.toInt(array, 8), this.maxSpan);
        for (i = 0; i < this.maxSpan; ++i) {
            cur.addFrequency(i - this.maxSpan, ByteArrayConvert.toInt(array, 4 * i + 12));
        }
        for (i = 0; i < this.maxSpan; ++i) {
            cur.addFrequency(i + 1, ByteArrayConvert.toInt(array, 4 * (i + this.maxSpan) + 12));
        }
        return cur;
    }
}

