/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool.xtract;

import dragon.nlp.SimpleElementList;
import dragon.nlp.Token;
import dragon.nlp.extract.EngDocumentParser;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.Tagger;
import dragon.nlp.tool.xtract.EngWordPairExpand;
import dragon.nlp.tool.xtract.EngWordPairIndexer;
import dragon.nlp.tool.xtract.WordPairExpand;
import dragon.nlp.tool.xtract.WordPairFilter;
import dragon.nlp.tool.xtract.WordPairIndexer;
import dragon.nlp.tool.xtract.WordPairStat;
import dragon.onlinedb.CollectionReader;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.util.ArrayList;

public class SimpleXtract {
    private int maxSpan;
    private String indexFolder;

    public SimpleXtract(int maxSpan, String workingDir) {
        this.maxSpan = maxSpan;
        this.indexFolder = workingDir;
    }

    public void index(CollectionReader cr, Tagger tagger, Lemmatiser lemmatiser) {
        this.index(cr, tagger, lemmatiser);
    }

    public void index(CollectionReader cr, Tagger tagger, Lemmatiser lemmatiser, String wordDelimitor) {
        CollectionReader[] arrReader = new CollectionReader[]{cr};
        this.index(arrReader, tagger, lemmatiser, wordDelimitor);
    }

    public void index(CollectionReader[] cr, Tagger tagger, Lemmatiser lemmatiser) {
        this.index(cr, tagger, lemmatiser, null);
    }

    public void index(CollectionReader[] cr, Tagger tagger, Lemmatiser lemmatiser, String wordDelimitor) {
        EngWordPairIndexer indexer = new EngWordPairIndexer(this.indexFolder, this.maxSpan, tagger, lemmatiser);
        if (wordDelimitor != null && wordDelimitor.length() > 0) {
            indexer.setDocumentParser(new EngDocumentParser(wordDelimitor));
        }
        for (int i = 0; i < cr.length; ++i) {
            indexer.index(cr[i]);
        }
        indexer.close();
    }

    public void index(CollectionReader cr, WordPairIndexer indexer) {
        CollectionReader[] arrReader = new CollectionReader[]{cr};
        this.index(arrReader, indexer);
    }

    public void index(CollectionReader[] cr, WordPairIndexer indexer) {
        for (int i = 0; i < cr.length; ++i) {
            indexer.index(cr[i]);
        }
        indexer.close();
    }

    public void extract(double minStrength, double minSpread, double minZScore, double minExpandRatio, String outputFile) {
        EngWordPairExpand expander = new EngWordPairExpand(this.maxSpan, this.indexFolder, minExpandRatio);
        this.extract(expander, minStrength, minSpread, minZScore, outputFile);
    }

    public void extract(WordPairExpand expander, double minStrength, double minSpread, double minZScore, String outputFile) {
        SortedArray phraseList = new SortedArray();
        PrintWriter screen = FileUtil.getScreen();
        WordPairStat[] arrStat = this.filter(minStrength, minSpread, minZScore);
        for (int i = 0; i < arrStat.length; ++i) {
            for (int j = 1; j < this.maxSpan; ++j) {
                if (arrStat[i].getFrequency(j) > 0) {
                    this.addPhrase(expander.expand(arrStat[i], j), phraseList, screen);
                }
                if (arrStat[i].getFrequency(-j) <= 0) continue;
                this.addPhrase(expander.expand(arrStat[i], -j), phraseList, screen);
            }
        }
        this.printPhrase(phraseList, outputFile);
    }

    private void addPhrase(ArrayList inputList, SortedArray phraseList, PrintWriter screen) {
        if (inputList == null) {
            return;
        }
        for (int i = 0; i < inputList.size(); ++i) {
            Token token = (Token)inputList.get(i);
            if (!phraseList.add(token)) {
                Token old = (Token)phraseList.get(phraseList.insertedPos());
                old.setFrequency(Math.max(old.getFrequency(), token.getFrequency()));
            }
            screen.println(token.getValue() + "  " + token.getFrequency());
        }
    }

    private WordPairStat[] filter(double minStrength, double minSpread, double minZScore) {
        WordPairFilter pairFilter = new WordPairFilter(this.indexFolder, this.maxSpan, minStrength, minSpread, minZScore);
        WordPairStat[] arrStat = pairFilter.execute();
        return arrStat;
    }

    private void printPhrase(SortedArray list, String filename) {
        try {
            BufferedWriter bw = FileUtil.getTextWriter(filename);
            bw.write(list.size() + "\n");
            for (int i = 0; i < list.size(); ++i) {
                Token token = (Token)list.get(i);
                bw.write(token.getValue());
                bw.write(9 + token.getFrequency());
                bw.write(10);
                bw.flush();
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void printWordPair(WordPairStat[] arrStat, String filename) {
        try {
            SimpleElementList wordkeyList = new SimpleElementList(this.indexFolder + "/wordkey.list", false);
            SortedArray pairList = new SortedArray();
            for (int i = 0; i < arrStat.length; ++i) {
                String pair = wordkeyList.search(arrStat[i].getFirstWord()) + " " + wordkeyList.search(arrStat[i].getSecondWord());
                pairList.add(pair.toLowerCase());
            }
            this.printPhrase(pairList, filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

