/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool.xtract;

import dragon.matrix.IntFlatSparseMatrix;
import dragon.matrix.SparseMatrixFactory;
import dragon.nlp.Sentence;
import dragon.nlp.Word;

public class SentenceBase {
    private SparseMatrixFactory factory;
    private IntFlatSparseMatrix cacheMatrix;
    private String indexFile;
    private int sentenceNum;
    private int threshold;

    public SentenceBase(String indexFile, String matrixFile) {
        this.indexFile = indexFile;
        this.factory = new SparseMatrixFactory(matrixFile, 4);
        this.cacheMatrix = new IntFlatSparseMatrix();
        this.sentenceNum = this.factory.rows();
        this.threshold = 500000;
    }

    public int addSentence(Sentence sent) {
        int sentIndex = this.sentenceNum++;
        Word cur = sent.getFirstWord();
        while (cur != null) {
            this.cacheMatrix.add(sentIndex, cur.getIndex(), cur.getPOSIndex());
            cur = cur.next;
        }
        if (this.cacheMatrix.getNonZeroNum() >= this.threshold) {
            this.cacheMatrix.finalizeData(false);
            this.factory.add(this.cacheMatrix);
            this.cacheMatrix.close();
        }
        return sentIndex;
    }

    public void close() {
        this.cacheMatrix.finalizeData(false);
        this.factory.add(this.cacheMatrix);
        this.cacheMatrix.close();
        this.factory.genIndexFile(this.indexFile);
    }
}

