/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool.xtract;

import dragon.nlp.Sentence;
import dragon.nlp.Word;
import dragon.nlp.tool.xtract.WordPairGenerator;
import dragon.nlp.tool.xtract.WordPairStat;
import dragon.util.SortedArray;

public class EngWordPairGenerator
implements WordPairGenerator {
    protected int maxSpan;
    protected SortedArray list;

    public EngWordPairGenerator(int maxSpan) {
        this.maxSpan = maxSpan;
        this.list = new SortedArray();
    }

    @Override
    public void setMaxSpan(int maxSpan) {
        this.maxSpan = maxSpan;
    }

    @Override
    public int generate(Sentence sent) {
        this.list.clear();
        Word start = sent.getFirstWord();
        while (start != null) {
            if (start.getPOSIndex() != 1 && start.getPOSIndex() != 3) {
                start = start.next;
                continue;
            }
            Word end = start.next;
            for (int span = 1; end != null && span <= this.maxSpan; ++span) {
                int pos = end.getPOSIndex();
                if (pos == 1) {
                    WordPairStat curPair;
                    if (start.getIndex() <= end.getIndex()) {
                        curPair = new WordPairStat(start.getIndex(), end.getIndex(), this.maxSpan);
                        curPair.addFrequency(span, 1);
                        if (!this.list.add(curPair)) {
                            curPair = (WordPairStat)this.list.get(this.list.insertedPos());
                            curPair.addFrequency(span, 1);
                        }
                    } else {
                        curPair = new WordPairStat(end.getIndex(), start.getIndex(), this.maxSpan);
                        curPair.addFrequency(0 - span, 1);
                        if (!this.list.add(curPair)) {
                            curPair = (WordPairStat)this.list.get(this.list.insertedPos());
                            curPair.addFrequency(0 - span, 1);
                        }
                    }
                } else if (pos != 3) break;
                end = end.next;
            }
            start = start.next;
        }
        return this.list.size();
    }

    @Override
    public WordPairStat getWordPairs(int index) {
        return (WordPairStat)this.list.get(index);
    }
}

