/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool.xtract;

import dragon.matrix.IntGiantSparseMatrix;
import dragon.matrix.IntSparseMatrix;
import dragon.matrix.IntSuperSparseMatrix;
import dragon.nlp.SimpleElementList;
import dragon.nlp.Token;
import dragon.nlp.compare.FrequencyComparator;
import dragon.nlp.tool.xtract.WordPairExpand;
import dragon.nlp.tool.xtract.WordPairStat;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class EngWordPairExpand
implements WordPairExpand {
    protected IntSparseMatrix sentMatrix;
    protected SimpleElementList wordList;
    protected int maxSpan;
    protected String indexFolder;
    protected IntSparseMatrix[] arrPairSentLeftMatrix;
    protected IntSparseMatrix[] arrPairSentRightMatrix;
    protected double threshold;

    public EngWordPairExpand(int maxSpan, String indexFolder, double threshold) {
        int i;
        this.maxSpan = maxSpan;
        this.threshold = threshold;
        this.indexFolder = indexFolder;
        this.wordList = new SimpleElementList(indexFolder + "/wordkey.list", false);
        this.arrPairSentRightMatrix = new IntSparseMatrix[maxSpan];
        this.sentMatrix = new IntSuperSparseMatrix(indexFolder + "/sentencebase.index", indexFolder + "/sentencebase.matrix");
        for (i = 1; i <= maxSpan; ++i) {
            this.arrPairSentRightMatrix[i - 1] = new IntGiantSparseMatrix(indexFolder + "/pairsentr" + i + ".index", indexFolder + "/pairsentr" + i + ".matrix");
        }
        this.arrPairSentLeftMatrix = new IntSparseMatrix[maxSpan];
        for (i = 1; i <= maxSpan; ++i) {
            this.arrPairSentLeftMatrix[i - 1] = new IntGiantSparseMatrix(indexFolder + "/pairsentl" + i + ".index", indexFolder + "/pairsentl" + i + ".matrix");
        }
    }

    @Override
    public ArrayList expand(WordPairStat wordPairStat, int span) {
        try {
            Token token;
            int firstWord = wordPairStat.getFirstWord();
            int secondWord = wordPairStat.getSecondWord();
            String expandStr = null;
            ArrayList sentList = this.getSentenceList(wordPairStat, span);
            int sentNum = sentList.size();
            boolean pass = true;
            if (span > 1 || span < -1) {
                token = span > 1 ? this.expandSecion(1, span - 1, sentNum, false, 0, sentList) : this.expandSecion(1, -span - 1, sentNum, true, 0, sentList);
                if (token == null) {
                    pass = false;
                } else {
                    pass = true;
                    sentList = (ArrayList)token.getMemo();
                    expandStr = span > 1 ? this.getWordContent(firstWord) + " " + token.getName().trim() + " " + this.getWordContent(secondWord) : this.getWordContent(secondWord) + " " + token.getName().trim() + " " + this.getWordContent(firstWord);
                }
            } else {
                expandStr = span == 1 ? (this.getWordContent(firstWord) + " " + this.getWordContent(secondWord)).trim() : (this.getWordContent(secondWord).trim() + " " + this.getWordContent(firstWord)).trim();
            }
            if (!pass) {
                return null;
            }
            token = span > 0 ? this.expandSecion(1, this.maxSpan, sentNum, true, -1, sentList) : this.expandSecion(-span + 1, this.maxSpan - span, sentNum, true, -1, sentList);
            if (token != null) {
                sentList = (ArrayList)token.getMemo();
                expandStr = token.getName().trim() + " " + expandStr;
            }
            if ((token = span > 0 ? this.expandSecion(span + 1, span + this.maxSpan, sentNum, false, 1, sentList) : this.expandSecion(1, this.maxSpan, sentNum, false, 1, sentList)) != null) {
                sentList = (ArrayList)token.getMemo();
                expandStr = expandStr + " " + token.getName().trim();
            }
            ArrayList<Token> phraseList = new ArrayList<Token>(1);
            phraseList.add(new Token(expandStr.trim()));
            return phraseList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ArrayList getSentenceList(WordPairStat wordPairStat, int span) {
        int pairIndex = wordPairStat.getIndex();
        int firstWord = wordPairStat.getFirstWord();
        int secondWord = wordPairStat.getSecondWord();
        IntSparseMatrix pairSentMatrix = span < 0 ? this.arrPairSentLeftMatrix[-span - 1] : this.arrPairSentRightMatrix[span - 1];
        int sentNum = pairSentMatrix.getNonZeroNumInRow(pairIndex);
        ArrayList<Token> sentList = new ArrayList<Token>(sentNum);
        block0: for (int i = 0; i < sentNum; ++i) {
            int sentIndex = pairSentMatrix.getNonZeroColumnInRow(pairIndex, i);
            int sentLength = this.sentMatrix.getNonZeroNumInRow(sentIndex);
            for (int j = 0; j < sentLength; ++j) {
                int wordKey = this.sentMatrix.getNonZeroColumnInRow(sentIndex, j);
                if (wordKey != firstWord) continue;
                if (j + span < 0 || j + span >= sentLength || this.sentMatrix.getNonZeroColumnInRow(sentIndex, j + span) != secondWord) continue block0;
                Token sentToken = new Token(String.valueOf(sentIndex));
                sentToken.setIndex(j);
                sentToken.setFrequency(this.sentMatrix.getNonZeroIntScoreInRow(sentIndex, j + span));
                sentList.add(sentToken);
                continue block0;
            }
        }
        return sentList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Token expandSecion(int start, int end, int sentNum, boolean inverse, int direction, ArrayList sentList) {
        int j;
        Token token;
        int i;
        String expandStr = "";
        String marginalWord = null;
        int marginalPOS = -1;
        for (i = start; i <= end && (token = this.checkSentPos(j = inverse ? -i : i, sentList)) != null; ++i) {
            sentList = (ArrayList)token.getMemo();
            if (!((double)token.getFrequency() / (double)sentNum >= this.threshold)) break;
            String word = this.getWordContent(Integer.parseInt(token.getName()));
            int posIndex = token.getIndex();
            if (direction != 0 && !this.checkValidation(word, posIndex)) break;
            expandStr = inverse ? word + " " + expandStr : expandStr + " " + word;
            expandStr = expandStr.trim();
            if ((direction != 1 || inverse) && (direction != -1 || !inverse)) continue;
            marginalWord = word;
            marginalPOS = posIndex;
        }
        if (i <= end && direction == 0) {
            return null;
        }
        if (expandStr.equals("")) return null;
        if (direction == 1 && !inverse && !this.checkEndingWordValidation(marginalWord, marginalPOS)) {
            int pos = expandStr.lastIndexOf(32);
            if (pos < 0) return null;
            expandStr = expandStr.substring(0, pos);
        } else if (direction == -1 && inverse && !this.checkStartingWordValidation(marginalWord, marginalPOS)) {
            int pos = expandStr.indexOf(32);
            if (pos < 0) return null;
            expandStr = expandStr.substring(pos + 1);
        }
        token = new Token(expandStr);
        token.setMemo(sentList);
        return token;
    }

    protected Token checkSentPos(int spanFromFirstWord, ArrayList sentList) {
        Token wordToken;
        SortedArray tokenList = new SortedArray();
        for (int i = 0; i < sentList.size(); ++i) {
            ArrayList sList;
            Token sentToken = (Token)sentList.get(i);
            int sentIndex = Integer.parseInt(sentToken.getName());
            int sentLength = this.sentMatrix.getNonZeroNumInRow(sentIndex);
            int firstWordPos = sentToken.getIndex();
            if (firstWordPos + spanFromFirstWord < 0 || firstWordPos + spanFromFirstWord >= sentLength) continue;
            int wordKey = this.sentMatrix.getNonZeroColumnInRow(sentIndex, firstWordPos + spanFromFirstWord);
            wordToken = new Token(String.valueOf(wordKey));
            int tokenIndex = tokenList.binarySearch(wordToken);
            if (tokenIndex < 0) {
                sList = new ArrayList();
                sList.add(sentToken);
                wordToken.setFrequency(1);
                wordToken.setIndex(this.sentMatrix.getNonZeroIntScoreInRow(sentIndex, firstWordPos + spanFromFirstWord));
                wordToken.setMemo(sList);
                tokenList.add(wordToken);
                continue;
            }
            wordToken = (Token)tokenList.get(tokenIndex);
            wordToken.addFrequency(1);
            sList = (ArrayList)wordToken.getMemo();
            sList.add(sentToken);
        }
        if (tokenList.size() > 0) {
            tokenList.setComparator(new FrequencyComparator(true));
            wordToken = (Token)tokenList.get(0);
            tokenList.clear();
            return wordToken;
        }
        return null;
    }

    protected String getWordContent(int index) {
        return this.wordList.search(index).trim();
    }

    protected boolean checkValidation(String word, int posIndex) {
        return posIndex == 3 || posIndex == 1 || posIndex == 0 && word.equals("-");
    }

    protected boolean checkEndingWordValidation(String word, int posIndex) {
        return posIndex == 1;
    }

    protected boolean checkStartingWordValidation(String word, int posIndex) {
        return posIndex == 1 || posIndex == 3;
    }
}

