/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool.lemmatiser;

import dragon.nlp.tool.lemmatiser.Operation;

public class SuffixEDetachOperation
implements Operation {
    private String vowel;
    private String suffix;
    private int pos;
    private boolean indexLookupOption;

    SuffixEDetachOperation(int POS2, String suffix) {
        this.pos = POS2;
        this.suffix = suffix;
        this.vowel = "aieou";
        this.indexLookupOption = true;
    }

    @Override
    public boolean getIndexLookupOption() {
        return this.indexLookupOption;
    }

    public void setIndexLookupOption(boolean option) {
        this.indexLookupOption = option;
    }

    @Override
    public String execute(String derivation) {
        if (derivation.length() > this.suffix.length() && derivation.endsWith(this.suffix)) {
            String base = derivation.substring(0, derivation.length() - this.suffix.length());
            if (!this.endingEPattern(base)) {
                return base;
            }
            return base + "e";
        }
        return null;
    }

    private boolean endingEPattern(String base) {
        int len = base.length();
        if (len < 3) {
            return false;
        }
        return this.vowel.indexOf(base.charAt(len - 1)) < 0 && this.vowel.indexOf(base.charAt(len - 2)) >= 0 && this.vowel.indexOf(base.charAt(len - 3)) < 0;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public int getPOSIndex() {
        return this.pos;
    }
}

