/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool;

import dragon.nlp.Sentence;
import dragon.nlp.Word;
import dragon.nlp.tool.AbstractTagger;
import dragon.nlp.tool.Tagger;
import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import hepple.postag.POSTagger;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class HeppleTagger
extends AbstractTagger
implements Tagger {
    private POSTagger tag;

    public HeppleTagger() {
        this(EnvVariable.getDragonHome() + "/nlpdata/tagger");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeppleTagger(String workDir) {
        String oldProtocolHandlerProp = System.getProperty("java.protocol.handler.pkgs");
        try {
            if (!FileUtil.exist(workDir) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + workDir)) {
                workDir = EnvVariable.getDragonHome() + "/" + workDir;
            }
            File fileLexicon = new File(workDir + "/lexicon_all");
            File fileRules = new File(workDir + "/rules_cap");
            URL urlLexicon = fileLexicon.toURI().toURL();
            URL urlRules = fileRules.toURI().toURL();
            String classpath = null;
            if (!(fileLexicon.exists() && fileRules.exists() || !workDir.contains("!"))) {
                classpath = "classpath:" + workDir.substring(workDir.indexOf(33) + 1);
                System.setProperty("java.protocol.handler.pkgs", "de.julielab.protocols");
            }
            if (!fileLexicon.exists()) {
                urlLexicon = new URL(classpath + "/lexicon_all");
            }
            if (!fileRules.exists()) {
                urlRules = new URL(classpath + "/rules_cap");
            }
            this.tag = new POSTagger(urlLexicon, urlRules);
            if (this.tag == null) {
                System.out.println("Failed to create POS tagger");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (oldProtocolHandlerProp != null) {
                System.setProperty("java.protocol.handler.pkgs", oldProtocolHandlerProp);
            } else {
                System.clearProperty("java.protocol.handler.pkgs");
            }
        }
    }

    @Override
    public void tag(Sentence sent) {
        ArrayList<String> sentenceForTagger = new ArrayList<String>();
        ArrayList<ArrayList<String>> sentencesForTagger = new ArrayList<ArrayList<String>>(1);
        sentencesForTagger.add(sentenceForTagger);
        Word word = sent.getFirstWord();
        while (word != null) {
            sentenceForTagger.add(word.getContent());
            word = word.next;
        }
        List result = this.tag.runTagger(sentencesForTagger);
        if (result.size() <= 0) {
            return;
        }
        result = (List)result.get(0);
        word = sent.getFirstWord();
        for (int i = 0; i < result.size(); ++i) {
            String[] output = (String[])result.get(i);
            word.setPOS(output[1], this.getPOSIndex(output[1], word));
            word = word.next;
        }
    }

    @Override
    protected int getPOSIndex(String pos, Word word) {
        int posIndex;
        if (word.isPunctuation()) {
            pos = word.getContent();
            posIndex = 0;
        } else {
            posIndex = pos.startsWith("N") ? 1 : (pos.startsWith("VB") ? 2 : (pos.startsWith("JJ") ? 3 : (pos.startsWith("RB") ? 4 : (pos.startsWith("CC") ? 8 : (pos.startsWith("DT") ? 7 : (pos.startsWith("PRP") ? 6 : (pos.startsWith("IN") ? (this.isConjunction(word.getContent()) ? 8 : 5) : (pos.startsWith("TO") ? 5 : (pos.startsWith("CD") ? (word.isNumber() ? 9 : 1) : (pos.startsWith("W") ? 8 : 0))))))))));
        }
        if (posIndex > 0 && posIndex != 1 && word.isAllCapital()) {
            posIndex = 1;
        }
        return posIndex;
    }
}

