/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool;

import dragon.nlp.Sentence;
import dragon.nlp.Word;
import dragon.nlp.extract.EngDocumentParser;
import dragon.nlp.tool.AbstractTagger;
import dragon.nlp.tool.Tagger;
import dragon.util.EnvVariable;

public class BrillTagger
extends AbstractTagger
implements Tagger {
    public static void main(String[] args) {
        BrillTagger tagger = new BrillTagger();
        EngDocumentParser parser = new EngDocumentParser();
        Sentence sent = parser.parseSentence("five osmanthus producing areas");
        tagger.tag(sent);
        System.out.println(sent.toPOSTaggedString());
    }

    public BrillTagger() {
        this(EnvVariable.getDragonHome() + "/nlpdata/tagger/brill");
    }

    public BrillTagger(String dataDir) {
        this.initialize(dataDir + "/BIGRAMS", dataDir + "/CONTEXTUALRULEFILE", dataDir + "/LEXICALRULEFILE", dataDir + "/LEXICON");
    }

    @Override
    public void tag(Sentence sent) {
        String tagged = this.tag(sent.toBrillTaggerString());
        String[] splitted = tagged.split(" ");
        Word word = sent.getFirstWord();
        for (int i = 0; i < splitted.length - 1; ++i) {
            int start = splitted[i].lastIndexOf(47);
            String tag = splitted[i].substring(start + 1);
            word.setPOS(tag, this.getPOSIndex(tag, word));
            word = word.next;
        }
    }

    @Override
    protected int getPOSIndex(String pos, Word word) {
        int posIndex;
        if (word.isPunctuation()) {
            pos = word.getContent();
            posIndex = 0;
        } else {
            posIndex = pos.startsWith("N") ? 1 : (pos.startsWith("VB") ? 2 : (pos.startsWith("JJ") ? 3 : (pos.startsWith("RB") ? 4 : (pos.startsWith("CC") ? 8 : (pos.startsWith("DT") ? 7 : (pos.startsWith("PRP") ? 6 : (pos.startsWith("IN") ? (this.isConjunction(word.getContent()) ? 8 : 5) : (pos.startsWith("TO") ? 5 : (pos.startsWith("CD") ? (word.isNumber() ? 9 : 1) : (pos.startsWith("W") ? 8 : 0))))))))));
        }
        if (posIndex > 0 && posIndex != 1 && word.isAllCapital()) {
            posIndex = 1;
        }
        return posIndex;
    }

    public native void initialize(String var1, String var2, String var3, String var4);

    public native void close();

    public native String tag(String var1);

    static {
        System.loadLibrary("brilltagger");
    }
}

