/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool;

import dragon.nlp.Document;
import dragon.nlp.Paragraph;
import dragon.nlp.Sentence;
import dragon.nlp.Term;
import dragon.nlp.Token;
import dragon.nlp.Word;
import dragon.nlp.tool.NER;
import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.corpora.DocumentImpl;
import gate.creole.ANNIEConstants;
import gate.creole.SerialAnalyserController;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Annie
implements NER {
    private SerialAnalyserController annieController;
    private Corpus corpus;
    private Set annotTypesRequired;

    public Annie() throws Exception {
        this.initAnnie(EnvVariable.getDragonHome() + "/nlpdata/gate");
    }

    public Annie(String gateHome) throws Exception {
        if (!FileUtil.exist(gateHome) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + gateHome)) {
            gateHome = EnvVariable.getDragonHome() + "/" + gateHome;
        }
        this.initAnnie(gateHome);
    }

    public void initAnnie(String gateHome) throws Exception {
        Gate.setGateHome((File)new File(gateHome));
        Gate.setPluginsHome((File)new File(gateHome));
        Gate.setUserConfigFile((File)new File(Gate.getGateHome(), "gate.xml"));
        Gate.init();
        Gate.getCreoleRegister().registerDirectories(new File(Gate.getGateHome(), "ANNIE").toURL());
        System.out.println("Initializing ANNIE...");
        this.annieController = (SerialAnalyserController)Factory.createResource((String)"gate.creole.SerialAnalyserController", (FeatureMap)Factory.newFeatureMap(), (FeatureMap)Factory.newFeatureMap(), (String)("ANNIE_" + Gate.genSym()));
        for (int i = 0; i < ANNIEConstants.PR_NAMES.length - 1; ++i) {
            FeatureMap params = Factory.newFeatureMap();
            ProcessingResource pr = (ProcessingResource)Factory.createResource((String)ANNIEConstants.PR_NAMES[i], (FeatureMap)params);
            this.annieController.add(pr);
        }
        System.out.println("...ANNIE loaded");
        this.corpus = (Corpus)Factory.createResource((String)"gate.corpora.CorpusImpl");
        this.annotTypesRequired = new HashSet();
        this.annotTypesRequired.add("Person");
        this.annotTypesRequired.add("Location");
        this.annotTypesRequired.add("Organization");
    }

    @Override
    public void setAnnotationTypes(String[] arrType) {
        if (arrType == null || arrType.length == 0) {
            return;
        }
        this.annotTypesRequired = new HashSet();
        for (int i = 0; i < arrType.length; ++i) {
            this.annotTypesRequired.add(arrType[i]);
        }
    }

    public void close() {
        this.annieController.cleanup();
    }

    @Override
    public ArrayList extractEntities(String content) {
        try {
            content = content.replaceAll("\r\n", " ");
            content = content.replace('\r', ' ');
            content = content.replace('\n', ' ');
            SortedArray entityList = new SortedArray();
            DocumentImpl doc = new DocumentImpl();
            doc.setStringContent(content);
            doc.init();
            this.corpus.clear();
            this.corpus.add((Object)doc);
            this.annieController.setCorpus(this.corpus);
            this.annieController.execute();
            AnnotationSet defaultAnnotSet = doc.getAnnotations();
            defaultAnnotSet = defaultAnnotSet.get(this.annotTypesRequired);
            if (defaultAnnotSet == null) {
                return null;
            }
            for (Annotation curAnnotation : defaultAnnotSet) {
                Token curToken = new Token(content.substring(curAnnotation.getStartNode().getOffset().intValue(), curAnnotation.getEndNode().getOffset().intValue()));
                if (entityList.add(curToken)) continue;
                curToken = (Token)entityList.get(entityList.insertedPos());
                curToken.addFrequency(1);
            }
            doc.cleanup();
            return entityList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ArrayList extractFromDoc(Document doc) {
        try {
            ArrayList termList = new ArrayList(60);
            Paragraph pg = doc.getFirstParagraph();
            while (pg != null) {
                Sentence sent = pg.getFirstSentence();
                while (sent != null) {
                    ArrayList curTermList = this.extractFromSentence(sent);
                    if (curTermList != null) {
                        termList.addAll(curTermList);
                        curTermList.clear();
                    }
                    sent = sent.next;
                }
                pg = pg.next;
            }
            return termList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ArrayList extractFromSentence(Sentence sent) {
        try {
            StringBuffer content = new StringBuffer();
            Word curWord = sent.getFirstWord();
            while (curWord != null) {
                if (content.length() > 0) {
                    content.append(' ');
                }
                curWord.setOffset(content.length());
                content.append(curWord.getContent());
                curWord = curWord.next;
            }
            if (content.toString().trim().length() <= 20) {
                return null;
            }
            DocumentImpl doc = new DocumentImpl();
            doc.setStringContent(content.toString());
            doc.init();
            this.corpus.clear();
            this.corpus.add((Object)doc);
            this.annieController.setCorpus(this.corpus);
            this.annieController.execute();
            AnnotationSet defaultAnnotSet = doc.getAnnotations();
            defaultAnnotSet = defaultAnnotSet.get(this.annotTypesRequired);
            if (defaultAnnotSet == null) {
                return null;
            }
            SortedArray annotationList = new SortedArray(new AnnotationComparator());
            Iterator it = defaultAnnotSet.iterator();
            if (it == null) {
                return null;
            }
            while (it.hasNext()) {
                annotationList.add(it.next());
            }
            ArrayList<Term> termList = new ArrayList<Term>(annotationList.size());
            curWord = sent.getFirstWord();
            for (int i = 0; i < annotationList.size(); ++i) {
                Annotation annot = (Annotation)annotationList.get(i);
                int start = annot.getStartNode().getOffset().intValue();
                int end = annot.getEndNode().getOffset().intValue();
                while (curWord.getOffset() < start) {
                    curWord = curWord.next;
                }
                if (curWord.getOffset() != start) continue;
                Word startWord = curWord;
                Word endWord = curWord;
                curWord = curWord.next;
                while (curWord != null && curWord.getOffset() < end) {
                    endWord = curWord;
                    curWord = curWord.next;
                }
                Term curTerm = new Term(startWord, endWord);
                curTerm.setTUI(annot.getType());
                termList.add(curTerm);
                if (startWord.getAssociatedConcept() != null) {
                    startWord.setAssociatedConcept(curTerm);
                }
                curWord = startWord;
            }
            return termList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String annotate(String original) {
        try {
            DocumentImpl doc = new DocumentImpl();
            doc.setStringContent(original);
            doc.init();
            this.corpus.clear();
            this.corpus.add((Object)doc);
            this.annieController.setCorpus(this.corpus);
            this.annieController.execute();
            AnnotationSet defaultAnnotSet = doc.getAnnotations();
            defaultAnnotSet = defaultAnnotSet.get(this.annotTypesRequired);
            return "<?xml version=\"1.0\" encoding=\"windows-1252\"?>\n<doc>" + doc.toXml((Set)defaultAnnotSet, false) + "</doc>";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private class AnnotationComparator
    implements Comparator {
        private AnnotationComparator() {
        }

        public int compare(Object firstObj, Object secondObj) {
            long start2;
            long start1 = ((Annotation)firstObj).getStartNode().getOffset();
            if (start1 < (start2 = ((Annotation)secondObj).getStartNode().getOffset().longValue())) {
                return -1;
            }
            if (start1 == start2) {
                long end2;
                long end1 = ((Annotation)firstObj).getEndNode().getOffset();
                if (end1 > (end2 = ((Annotation)secondObj).getEndNode().getOffset().longValue())) {
                    return -1;
                }
                if (end1 < end2) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }
    }
}

