/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.tool;

import dragon.nlp.Word;

public class AbstractTagger {
    private int conjNum = 9;
    private String[] arrConj = new String[this.conjNum];

    public AbstractTagger() {
        this.arrConj[0] = "although";
        this.arrConj[1] = "because";
        this.arrConj[2] = "but";
        this.arrConj[3] = "if";
        this.arrConj[4] = "that";
        this.arrConj[5] = "though";
        this.arrConj[6] = "when";
        this.arrConj[7] = "whether";
        this.arrConj[8] = "while";
    }

    public boolean isConjunction(String content) {
        int low = 0;
        int high = this.conjNum - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            int result = this.arrConj[middle].compareToIgnoreCase(content);
            if (result == 0) {
                return true;
            }
            if (result > 0) {
                high = middle - 1;
                continue;
            }
            low = middle + 1;
        }
        return false;
    }

    protected int getPOSIndex(String pos, Word word) {
        int posIndex;
        if (word.isPunctuation()) {
            pos = word.getContent();
            posIndex = 0;
        } else {
            posIndex = pos.startsWith("N") ? 1 : (pos.startsWith("VB") ? 2 : (pos.startsWith("JJ") ? 3 : (pos.startsWith("RB") ? 4 : (pos.startsWith("CC") ? 8 : (pos.startsWith("DT") ? 7 : (pos.startsWith("PRP") ? 6 : (pos.startsWith("IN") ? 5 : (pos.startsWith("CD") ? 9 : (pos.startsWith("W") ? 8 : 0)))))))));
        }
        return posIndex;
    }
}

