/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.umls;

import dragon.nlp.Token;
import dragon.util.FastBinaryReader;
import dragon.util.FastBinaryWriter;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class UmlsTokenList
extends SortedArray {
    private static final long serialVersionUID = 1L;

    public UmlsTokenList() {
    }

    public UmlsTokenList(String tokenFile) {
        this.loadTokenList(tokenFile);
    }

    public UmlsTokenList(String tokenFile, boolean binary) {
        this.loadTokenList(tokenFile, binary);
    }

    public int addToken(Token token) {
        token.setIndex(this.size());
        if (this.add(token)) {
            token.setFrequency(1);
            return token.getIndex();
        }
        token = (Token)this.get(this.insertedPos());
        token.addFrequency(1);
        return token.getIndex();
    }

    public Token tokenAt(int index) {
        return (Token)this.get(index);
    }

    public Token lookup(String token) {
        int pos = this.binarySearch(new Token(token));
        if (pos < 0) {
            return null;
        }
        return (Token)this.get(pos);
    }

    public Token lookup(Token token) {
        int pos = this.binarySearch(token);
        if (pos < 0) {
            return null;
        }
        return (Token)this.get(pos);
    }

    private void loadTokenList(String tokenFilename) {
        try {
            System.out.println(new Date() + " Loading Token List...");
            BufferedReader br = FileUtil.getTextReader(tokenFilename);
            String line = br.readLine();
            int len = Integer.parseInt(line);
            ArrayList<Token> tokenList = new ArrayList<Token>(len);
            for (int i = 0; i < len; ++i) {
                line = br.readLine();
                String[] strArr = line.split("\t");
                Token token = new Token(strArr[1]);
                token.setIndex(Integer.parseInt(strArr[0]));
                int freq = Integer.parseInt(strArr[2]);
                token.setFrequency(freq);
                token.setWeight(1.0 / (double)freq);
                tokenList.add(token);
            }
            br.close();
            Collections.sort(tokenList);
            this.addAll(tokenList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadTokenList(String tokenFilename, boolean binary) {
        if (!binary) {
            this.loadTokenList(tokenFilename);
            return;
        }
        try {
            System.out.println(new Date() + " Loading Token List...");
            FastBinaryReader fbr = new FastBinaryReader(tokenFilename);
            byte[] buf = new byte[1024];
            int total = fbr.readInt();
            ArrayList<Token> tokenList = new ArrayList<Token>(total);
            for (int i = 0; i < total; ++i) {
                int index = fbr.readInt();
                short freq = fbr.readShort();
                int len = fbr.readShort();
                len = fbr.read(buf, 0, len);
                Token token = new Token(new String(buf, 0, len));
                token.setIndex(index);
                token.setFrequency(freq);
                token.setWeight(1.0 / (double)freq);
                tokenList.add(token);
            }
            fbr.close();
            Collections.sort(tokenList);
            this.addAll(tokenList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveTo(String filename) {
        try {
            System.out.println(new Date() + " Saving Token List...");
            BufferedWriter bw = FileUtil.getTextWriter(filename);
            bw.write(this.size() + "");
            bw.write("\n");
            for (int i = 0; i < this.size(); ++i) {
                Token t = (Token)this.get(i);
                bw.write(t.getIndex() + "\t" + t.getValue() + "\t" + t.getFrequency() + "\n");
                bw.flush();
            }
            bw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveTo(String filename, boolean binary) {
        if (!binary) {
            this.saveTo(filename);
            return;
        }
        try {
            FastBinaryWriter fbw = new FastBinaryWriter(filename);
            fbw.writeInt(this.size());
            for (int i = 0; i < this.size(); ++i) {
                Token token = this.tokenAt(i);
                fbw.writeInt(token.getIndex());
                fbw.writeShort(token.getFrequency());
                fbw.writeShort(token.getValue().length());
                fbw.writeBytes(token.getValue());
            }
            fbw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

