/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.umls;

import dragon.nlp.ontology.Ontology;
import dragon.nlp.ontology.SemanticNet;
import dragon.nlp.ontology.umls.UmlsRelationNet;
import dragon.nlp.ontology.umls.UmlsSTYList;

public class UmlsSemanticNet
implements SemanticNet {
    private Ontology ontology;
    private UmlsSTYList styList;
    private UmlsRelationNet relationNet;

    public UmlsSemanticNet(Ontology ontology, UmlsSTYList styList, UmlsRelationNet relationNet) {
        this.ontology = ontology;
        this.styList = styList;
        this.relationNet = relationNet;
    }

    @Override
    public String[] getRelations(String[] arrFirstST, String[] arrSecondST) {
        return this.relationNet.getRelations(arrFirstST, arrSecondST);
    }

    @Override
    public String[] getRelations(String firstST, String secondST) {
        String relation = this.relationNet.getRelations(firstST, secondST);
        if (relation == null) {
            return null;
        }
        String[] arrRelation = new String[]{relation};
        return arrRelation;
    }

    @Override
    public boolean isSemanticRelated(String[] arrFirstST, String[] arrSecondST) {
        return this.relationNet.isSemanticRelated(arrFirstST, arrSecondST);
    }

    @Override
    public boolean isSemanticRelated(String firstST, String secondST) {
        return this.relationNet.isSemanticRelated(firstST, secondST);
    }

    @Override
    public String getSemanticTypeDesc(String id) {
        return this.styList.lookup(id).getDescription();
    }

    @Override
    public String getRelationDesc(String id) {
        return this.styList.lookup(id).getDescription();
    }

    @Override
    public String getHierarchy(String id) {
        return this.styList.lookup(id).getHier();
    }

    @Override
    public Ontology getOntology() {
        return this.ontology;
    }
}

