/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.umls;

import dragon.nlp.ontology.umls.UmlsSTY;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;

public class UmlsSTYList
extends SortedArray {
    private static final long serialVersionUID = 1L;

    public static void main(String[] args) {
        UmlsSTYList list = new UmlsSTYList("sir/semantictype.list");
        System.out.println(list.lookup("T028").getDescription());
    }

    public UmlsSTYList(String styFile) {
        this.loadSTYList(styFile);
    }

    public UmlsSTYList(Connection con) {
        this.loadSTYList(con);
    }

    public UmlsSTY styAt(int index) {
        return (UmlsSTY)this.get(index);
    }

    public UmlsSTY lookup(String tui) {
        int pos = this.binarySearch(new UmlsSTY(0, tui, null, null, false));
        if (pos < 0) {
            return null;
        }
        return (UmlsSTY)this.get(pos);
    }

    public UmlsSTY lookup(UmlsSTY tui) {
        int pos = this.binarySearch(tui);
        if (pos < 0) {
            return null;
        }
        return (UmlsSTY)this.get(pos);
    }

    private boolean loadSTYList(String filename) {
        try {
            BufferedReader br = FileUtil.getTextReader(filename);
            String line = br.readLine();
            int total = Integer.parseInt(line);
            ArrayList<UmlsSTY> list = new ArrayList<UmlsSTY>(total);
            for (int i = 0; i < total; ++i) {
                line = br.readLine();
                String[] arrField = line.split("\t");
                boolean isRelation = !arrField[0].equals("STY");
                UmlsSTY cur = new UmlsSTY(i, arrField[1], arrField[2], arrField[3], isRelation);
                list.add(cur);
            }
            br.close();
            Collections.sort(list);
            this.addAll(list);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadSTYList(Connection con) {
        try {
            String sql = "select RT, UI, STYRL,STNRTN from SRDEF";
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            int count = 0;
            ArrayList<UmlsSTY> list = new ArrayList<UmlsSTY>();
            while (rs.next()) {
                boolean isRelation = !rs.getString("RT").equalsIgnoreCase("STY");
                UmlsSTY cur = new UmlsSTY(count, rs.getString("UI"), rs.getString("STYRL"), rs.getString("STNRTN"), isRelation);
                list.add(cur);
            }
            rs.close();
            st.close();
            Collections.sort(list);
            this.addAll(list);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

