/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.umls;

import dragon.nlp.Sentence;
import dragon.nlp.Term;
import dragon.nlp.Word;
import dragon.nlp.ontology.umls.UmlsOntology;
import dragon.nlp.tool.Lemmatiser;
import dragon.util.SortedArray;
import java.util.ArrayList;
import java.util.Collections;

public abstract class UmlsExactOntology
extends UmlsOntology {
    public UmlsExactOntology(Lemmatiser lemmatiser) {
        super(lemmatiser);
    }

    @Override
    public String[] getSemanticType(String[] cuis) {
        String[] arrTypes;
        int i;
        SortedArray typeList = new SortedArray(3);
        for (i = 0; i < cuis.length; ++i) {
            arrTypes = this.getSemanticType(cuis[i]);
            if (arrTypes == null) continue;
            for (int j = 0; j < arrTypes.length; ++j) {
                typeList.add(arrTypes[j]);
            }
        }
        if (typeList.size() > 0) {
            arrTypes = new String[typeList.size()];
            for (i = 0; i < typeList.size(); ++i) {
                arrTypes[i] = (String)typeList.get(i);
            }
            return arrTypes;
        }
        return null;
    }

    @Override
    public abstract String[] getSemanticType(String var1);

    @Override
    public abstract String[] getCUI(String var1);

    @Override
    public String[] getCUI(Word starting, Word ending) {
        return this.getCUI(this.buildNormalizedTerm(starting, ending));
    }

    @Override
    public abstract boolean isTerm(String var1);

    @Override
    public boolean isTerm(Word starting, Word ending) {
        return this.isTerm(this.buildNormalizedTerm(starting, ending));
    }

    @Override
    public ArrayList findAllTerms(Word start) {
        return this.findAllTerms(start, null);
    }

    @Override
    public ArrayList findAllTerms(Word start, Word end) {
        return null;
    }

    @Override
    public Term findTerm(Word start) {
        return this.findTerm(start, null);
    }

    @Override
    public Term findTerm(Word start, Word end) {
        int posIndex;
        Sentence sent = start.getParent();
        Word curWord = start.next;
        if (end == null) {
            int j = 0;
            while (j < 4 && curWord != null && end == null) {
                if (this.isBoundaryWord(curWord)) {
                    end = curWord.prev;
                }
                if (!curWord.isPunctuation()) {
                    ++j;
                }
                curWord = curWord.next;
            }
            if (curWord == null) {
                curWord = sent.getLastWord();
            }
            if (end == null) {
                end = curWord;
            }
        }
        curWord = end;
        String[] arrCandidateCUI = null;
        while (curWord != null && curWord.getPosInSentence() >= start.getPosInSentence() && ((posIndex = curWord.getPOSIndex()) != 1 && (posIndex != 9 || curWord.getPosInSentence() <= start.getPosInSentence()) || (arrCandidateCUI = this.getCUI(start, curWord)) == null)) {
            curWord = curWord.prev;
        }
        if (arrCandidateCUI == null) {
            return null;
        }
        Term curTerm = new Term(start, end);
        start.setAssociatedConcept(curTerm);
        curTerm.setCandidateCUI(arrCandidateCUI);
        if (arrCandidateCUI.length == 1) {
            curTerm.setCUI(arrCandidateCUI[0]);
        }
        if (curTerm.getCUI() == null) {
            curTerm.setCandidateTUI(this.getSemanticType(curTerm.getCandidateCUI()));
        } else {
            curTerm.setCandidateTUI(this.getSemanticType(curTerm.getCUI()));
        }
        if (curTerm.getCandidateTUINum() == 1) {
            curTerm.setTUI(curTerm.getCandidateTUI(0));
        }
        return curTerm;
    }

    public String buildNormalizedTerm(Word start, Word end) {
        if (start.equals(end)) {
            return this.getLemma(start);
        }
        ArrayList<String> list = new ArrayList<String>(6);
        Word next = start;
        while (next != null) {
            if (this.isUsefulForTerm(next)) {
                list.add(this.getLemma(next));
            }
            if (next.equals(end)) break;
            next = next.next;
        }
        Collections.sort(list);
        StringBuffer term = new StringBuffer((String)list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            term.append(' ');
            term.append((String)list.get(i));
        }
        return term.toString();
    }
}

