/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology.umls;

import dragon.nlp.compare.IndexComparator;
import dragon.nlp.ontology.umls.UmlsCUI;
import dragon.util.FastBinaryReader;
import dragon.util.FastBinaryWriter;
import dragon.util.FileUtil;
import dragon.util.FormatUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class UmlsCUIList
extends SortedArray {
    private static final long serialVersionUID = 1L;

    public UmlsCUIList() {
    }

    public UmlsCUIList(String cuiFile) {
        this.loadCUIList(cuiFile, false);
    }

    public UmlsCUIList(String cuiFile, boolean loadConceptName) {
        this.loadCUIList(cuiFile, loadConceptName);
    }

    public UmlsCUIList(String cuiFile, boolean binary, boolean loadConceptName) {
        this.loadCUIList(cuiFile, binary, loadConceptName);
    }

    public UmlsCUI cuiAt(int index) {
        return (UmlsCUI)this.get(index);
    }

    public ArrayList getListSortedByIndex() {
        ArrayList list = new ArrayList(this.size());
        list.addAll(this);
        Collections.sort(list, new IndexComparator());
        return list;
    }

    public boolean add(String cui, String[] stys) {
        UmlsCUI cur = new UmlsCUI(this.size(), cui, stys);
        return this.add(cur);
    }

    public UmlsCUI lookup(String cui) {
        int pos = this.binarySearch(new UmlsCUI(0, cui, null));
        if (pos < 0) {
            return null;
        }
        return (UmlsCUI)this.get(pos);
    }

    public UmlsCUI lookup(UmlsCUI cui) {
        int pos = this.binarySearch(cui);
        if (pos < 0) {
            return null;
        }
        return (UmlsCUI)this.get(pos);
    }

    public void saveTo(String filename) {
        try {
            System.out.println(new Date() + " Saving CUI List...");
            PrintWriter bw = FileUtil.getPrintWriter(filename);
            bw.write(this.size() + "\n");
            for (int i = 0; i < this.size(); ++i) {
                UmlsCUI cur = (UmlsCUI)this.get(i);
                bw.write(cur.getIndex() + "\t" + cur.toString() + "\t" + cur.getSTY(0));
                for (int j = 1; j < cur.getSTYNum(); ++j) {
                    bw.write("_" + cur.getSTY(j));
                }
                if (cur.getName() != null && cur.getName().length() > 0) {
                    bw.write("\t" + cur.getName());
                }
                bw.write(10);
                bw.flush();
            }
            bw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveTo(String filename, boolean binary) {
        if (!binary) {
            this.saveTo(filename);
            return;
        }
        try {
            FastBinaryWriter fbw = new FastBinaryWriter(filename);
            fbw.writeInt(this.size());
            for (int i = 0; i < this.size(); ++i) {
                UmlsCUI cui = this.cuiAt(i);
                fbw.writeInt(cui.getIndex());
                fbw.write(cui.getCUI().getBytes());
                fbw.writeShort(cui.getSTYNum());
                for (int j = 0; j < cui.getSTYNum(); ++j) {
                    fbw.writeShort(Integer.parseInt(cui.getSTY(j).substring(1)));
                }
            }
            fbw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean loadCUIList(String filename, boolean loadConceptName) {
        try {
            System.out.println(new Date() + " Loading CUI List...");
            BufferedReader br = FileUtil.getTextReader(filename);
            String line = br.readLine();
            int total = Integer.parseInt(line);
            ArrayList<UmlsCUI> list = new ArrayList<UmlsCUI>(total);
            String prevSTY = "";
            String[] prevArrSTY = null;
            for (int i = 0; i < total; ++i) {
                String[] arrSTY;
                line = br.readLine();
                String[] arrField = line.split("\t");
                if (prevSTY.equals(arrField[2])) {
                    arrSTY = prevArrSTY;
                } else {
                    arrSTY = arrField[2].split("_");
                    prevSTY = arrField[2];
                    prevArrSTY = arrSTY;
                }
                UmlsCUI cur = new UmlsCUI(Integer.parseInt(arrField[0]), arrField[1], arrSTY);
                if (arrField.length >= 4 && loadConceptName) {
                    cur.setName(arrField[3]);
                }
                list.add(cur);
            }
            br.close();
            Collections.sort(list);
            this.addAll(list);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean loadCUIList(String filename, boolean binary, boolean loadConceptName) {
        if (!binary) {
            return this.loadCUIList(filename, loadConceptName);
        }
        try {
            int i;
            System.out.println(new Date() + " Loading CUI List...");
            FastBinaryReader fbr = new FastBinaryReader(filename);
            int total = fbr.readInt();
            ArrayList<UmlsCUI> list = new ArrayList<UmlsCUI>(total);
            byte[] buf = new byte[8];
            String[] stys = new String[512];
            DecimalFormat df = FormatUtil.getNumericFormat(3, 0);
            for (i = 0; i < stys.length; ++i) {
                stys[i] = "T" + df.format(i);
            }
            for (i = 0; i < total; ++i) {
                int index = fbr.readInt();
                fbr.read(buf);
                String[] arrSTY = new String[fbr.readShort()];
                for (int j = 0; j < arrSTY.length; ++j) {
                    arrSTY[j] = stys[fbr.readShort()];
                }
                UmlsCUI cur = new UmlsCUI(index, new String(buf), arrSTY);
                list.add(cur);
            }
            fbr.close();
            Collections.sort(list);
            this.addAll(list);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

