/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology;

import dragon.nlp.Word;
import dragon.nlp.ontology.Vocabulary;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collections;

public class ChineseVocabulary
implements Vocabulary {
    private SortedArray list;
    private String[] arrPhrase;

    public ChineseVocabulary(String vobFile) {
        this.load(vobFile);
    }

    public int getPhraseIndex(long phraseUID) {
        int pos = this.list.binarySearch(new ChinesePhrase(phraseUID, -1));
        if (pos < 0) {
            return -1;
        }
        return ((ChinesePhrase)this.list.get(pos)).getIndex();
    }

    @Override
    public boolean isPhrase(String term) {
        return this.list.binarySearch(new ChinesePhrase(this.getUID(term), -1)) >= 0;
    }

    @Override
    public boolean isPhrase(Word start, Word end) {
        return false;
    }

    @Override
    public boolean isStartingWord(Word cur) {
        return true;
    }

    @Override
    public Word findPhrase(Word start) {
        return null;
    }

    @Override
    public int getPhraseNum() {
        return this.arrPhrase.length;
    }

    @Override
    public String getPhrase(int index) {
        return this.arrPhrase[index];
    }

    @Override
    public int maxPhraseLength() {
        return 4;
    }

    @Override
    public int minPhraseLength() {
        return 2;
    }

    @Override
    public void setAdjectivePhraseOption(boolean enabled) {
    }

    @Override
    public boolean getAdjectivePhraseOption() {
        return false;
    }

    @Override
    public void setNPPOption(boolean enabled) {
    }

    @Override
    public boolean getNPPOption() {
        return false;
    }

    @Override
    public void setCoordinateOption(boolean enabled) {
    }

    @Override
    public boolean getCoordinateOption() {
        return false;
    }

    @Override
    public void setLemmaOption(boolean enabled) {
    }

    @Override
    public boolean getLemmaOption() {
        return false;
    }

    public long getUID(String phrase) {
        if (phrase == null || phrase.length() > 4 || phrase.length() == 0) {
            return -1L;
        }
        long uid = phrase.charAt(0);
        for (int i = 1; i < phrase.length(); ++i) {
            uid = (uid << 16) + (long)phrase.charAt(i);
        }
        return uid;
    }

    private void load(String vobFile) {
        try {
            BufferedReader br = FileUtil.getTextReader(vobFile, "GBK");
            String line = br.readLine();
            String[] arrField = line.split("\t");
            int total = Integer.parseInt(arrField[0]);
            this.arrPhrase = new String[total];
            ArrayList<ChinesePhrase> phraseList = new ArrayList<ChinesePhrase>(total);
            for (int i = 0; i < total; ++i) {
                line = br.readLine();
                arrField = line.split("\t");
                this.arrPhrase[i] = arrField[0];
                if (this.arrPhrase[i].length() > 4) continue;
                phraseList.add(new ChinesePhrase(this.getUID(this.arrPhrase[i]), i));
            }
            Collections.sort(phraseList);
            this.list = new SortedArray(total);
            this.list.addAll(phraseList);
            phraseList.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ChinesePhrase
    implements Comparable {
        private long id;
        private int index;

        public ChinesePhrase(long id, int index) {
            this.id = id;
            this.index = index;
        }

        public int compareTo(Object obj) {
            long objId = ((ChinesePhrase)obj).getID();
            if (this.id > objId) {
                return 1;
            }
            if (this.id < objId) {
                return -1;
            }
            return 0;
        }

        public long getID() {
            return this.id;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

