/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology;

import dragon.nlp.Sentence;
import dragon.nlp.Word;
import dragon.nlp.ontology.AbstractVocabulary;
import dragon.nlp.tool.Lemmatiser;

public class BasicVocabulary
extends AbstractVocabulary {
    public BasicVocabulary(String termFilename) {
        super(termFilename);
    }

    public BasicVocabulary(String termFilename, Lemmatiser lemmatiser) {
        super(termFilename, lemmatiser);
    }

    @Override
    public boolean isPhrase(String term) {
        return this.list.contains(term);
    }

    @Override
    public boolean isPhrase(Word start, Word end) {
        return this.isPhrase(this.buildString(start, end, this.getLemmaOption()));
    }

    @Override
    public Word findPhrase(Word start) {
        int j;
        Sentence sent = start.getParent();
        Word curWord = start.next;
        Word end = null;
        for (j = 0; j < this.maxPhraseLength - 1 && curWord != null && end == null; ++j) {
            if (this.isBoundaryWord(curWord)) {
                end = curWord.prev;
            }
            curWord = curWord.next;
        }
        if (curWord == null) {
            curWord = sent.getLastWord();
        }
        if (end == null) {
            end = curWord;
            j = end.getPosInSentence() - start.getPosInSentence() + 1;
        }
        if (j < this.minPhraseLength) {
            return null;
        }
        curWord = end;
        boolean found = false;
        while (curWord != null && curWord.getPosInSentence() >= start.getPosInSentence() && j >= this.minPhraseLength) {
            int posIndex = curWord.getPOSIndex();
            if ((posIndex == 1 || posIndex == 9 && curWord.getPosInSentence() > start.getPosInSentence()) && this.isPhrase(start, curWord)) {
                found = true;
                break;
            }
            curWord = curWord.prev;
            --j;
        }
        if (found) {
            return curWord;
        }
        return null;
    }
}

