/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology;

import dragon.nlp.Sentence;
import dragon.nlp.Term;
import dragon.nlp.Word;
import dragon.nlp.ontology.AbstractOntology;
import dragon.nlp.ontology.BasicTerm;
import dragon.nlp.ontology.BasicTermList;
import dragon.nlp.tool.Lemmatiser;
import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import java.util.ArrayList;

public class BasicOntology
extends AbstractOntology {
    private BasicTermList list;

    public BasicOntology(String termFilename, Lemmatiser lemmatiser) {
        super(lemmatiser);
        if (!FileUtil.exist(termFilename) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + termFilename)) {
            termFilename = EnvVariable.getDragonHome() + "/" + termFilename;
        }
        this.setNonBoundaryPunctuation(".-");
        this.list = new BasicTermList(termFilename);
    }

    @Override
    public String[] getSemanticType(String[] cuis) {
        return null;
    }

    @Override
    public String[] getSemanticType(String cui) {
        return null;
    }

    @Override
    public String[] getCUI(String term) {
        BasicTerm cur = this.list.lookup(term);
        if (cur == null) {
            return null;
        }
        return cur.getAllCUI();
    }

    @Override
    public String[] getCUI(Word starting, Word ending) {
        return this.getCUI(this.buildString(starting, ending, this.getLemmaOption()));
    }

    @Override
    public boolean isTerm(String term) {
        return true;
    }

    @Override
    public boolean isTerm(Word starting, Word ending) {
        return this.isTerm(this.buildString(starting, ending, this.getLemmaOption()));
    }

    @Override
    public Term findTerm(Word starting) {
        return this.findTerm(starting, null);
    }

    @Override
    public Term findTerm(Word start, Word end) {
        int posIndex;
        Sentence sent = start.getParent();
        Word curWord = start.next;
        if (end == null) {
            for (int j = 0; j < 4 && curWord != null && end == null; ++j) {
                if (this.isBoundaryWord(curWord)) {
                    end = curWord.prev;
                }
                curWord = curWord.next;
            }
            if (curWord == null) {
                curWord = sent.getLastWord();
            }
            if (end == null) {
                end = curWord;
            }
        }
        curWord = end;
        String[] arrCandidateCUI = null;
        while (curWord != null && curWord.getPosInSentence() >= start.getPosInSentence() && ((posIndex = curWord.getPOSIndex()) != 1 && (posIndex != 9 || curWord.getPosInSentence() <= start.getPosInSentence()) || (arrCandidateCUI = this.getCUI(start, curWord)) == null)) {
            curWord = curWord.prev;
        }
        if (arrCandidateCUI == null) {
            return null;
        }
        Term curTerm = new Term(start, curWord);
        start.setAssociatedConcept(curTerm);
        curTerm.setCandidateCUI(arrCandidateCUI);
        if (arrCandidateCUI.length == 1) {
            curTerm.setCUI(arrCandidateCUI[0]);
        }
        return curTerm;
    }

    @Override
    public ArrayList findAllTerms(Word starting) {
        return this.findAllTerms(starting, null);
    }

    @Override
    public ArrayList findAllTerms(Word starting, Word ending) {
        Term cur = this.findTerm(starting, ending);
        if (cur == null) {
            return null;
        }
        ArrayList<Term> termList = new ArrayList<Term>(1);
        termList.add(cur);
        return termList;
    }
}

