/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology;

import dragon.nlp.SimpleElementList;
import dragon.nlp.Word;
import dragon.nlp.ontology.Vocabulary;
import dragon.nlp.tool.Lemmatiser;
import dragon.util.FileUtil;
import java.io.BufferedReader;

public abstract class AbstractVocabulary
implements Vocabulary {
    protected Lemmatiser lemmatiser;
    protected boolean enable_npp_option;
    protected boolean enable_coordinate_option;
    protected boolean enable_adjterm_option;
    protected boolean enable_lemma_option;
    protected String nonboundaryPunctuations;
    protected SimpleElementList list;
    protected int maxPhraseLength;
    protected int minPhraseLength;

    public AbstractVocabulary(String termFilename) {
        this.lemmatiser = null;
        this.enable_npp_option = false;
        this.enable_coordinate_option = false;
        this.enable_adjterm_option = false;
        this.enable_lemma_option = false;
        this.nonboundaryPunctuations = "-";
        this.list = new SimpleElementList(termFilename, false);
        this.readVocabularyMeta(termFilename);
    }

    public AbstractVocabulary(String termFilename, Lemmatiser lemmatiser) {
        this.lemmatiser = lemmatiser;
        this.enable_npp_option = false;
        this.enable_coordinate_option = false;
        this.enable_adjterm_option = false;
        this.enable_lemma_option = false;
        this.nonboundaryPunctuations = "-";
        this.list = new SimpleElementList(termFilename, false);
        this.readVocabularyMeta(termFilename);
    }

    @Override
    public int getPhraseNum() {
        return this.list.size();
    }

    @Override
    public String getPhrase(int index) {
        return this.list.search(index);
    }

    @Override
    public int maxPhraseLength() {
        return this.maxPhraseLength;
    }

    @Override
    public int minPhraseLength() {
        return this.minPhraseLength;
    }

    public void setNonBoundaryPunctuation(String punctuations) {
        this.nonboundaryPunctuations = punctuations;
    }

    public String getNonBoundaryPunctuation() {
        return this.nonboundaryPunctuations;
    }

    @Override
    public void setLemmaOption(boolean enabled) {
        this.enable_lemma_option = enabled;
    }

    @Override
    public boolean getLemmaOption() {
        return this.enable_lemma_option;
    }

    @Override
    public void setAdjectivePhraseOption(boolean enabled) {
        this.enable_adjterm_option = enabled;
    }

    @Override
    public boolean getAdjectivePhraseOption() {
        return this.enable_adjterm_option;
    }

    @Override
    public void setNPPOption(boolean enabled) {
        this.enable_npp_option = enabled;
    }

    @Override
    public boolean getNPPOption() {
        return this.enable_npp_option;
    }

    @Override
    public void setCoordinateOption(boolean enabled) {
        this.enable_coordinate_option = enabled;
    }

    @Override
    public boolean getCoordinateOption() {
        return this.enable_coordinate_option;
    }

    @Override
    public boolean isStartingWord(Word cur) {
        int posIndex = cur.getPOSIndex();
        if (posIndex == 1 || posIndex == 3) {
            return true;
        }
        return posIndex == 9 && cur.next != null && cur.next.getContent().equals("-");
    }

    protected boolean isBoundaryWord(Word curWord) {
        if (curWord.isPunctuation() && this.nonboundaryPunctuations.indexOf(curWord.getContent()) < 0) {
            return true;
        }
        if (curWord.prev != null && curWord.prev.getType() == 4) {
            return false;
        }
        int posIndex = curWord.getPOSIndex();
        if (posIndex == 2) {
            return true;
        }
        if (posIndex == 5) {
            if (!this.enable_npp_option) {
                return true;
            }
            if ("of".indexOf(curWord.getContent()) < 0) {
                return true;
            }
        }
        if (posIndex == 8) {
            if (!this.enable_coordinate_option) {
                return true;
            }
            if ("and or".indexOf(curWord.getContent()) < 0) {
                return true;
            }
        }
        return false;
    }

    protected String getLemma(Word word) {
        String lemma = word.getLemma();
        if (lemma == null) {
            lemma = word.getPOSIndex() >= 0 ? this.lemmatiser.lemmatize(word.getContent(), word.getPOSIndex()) : this.lemmatiser.lemmatize(word.getContent());
            word.setLemma(lemma);
        }
        return lemma;
    }

    protected String buildString(Word start, Word end, boolean useLemma) {
        String term;
        Word next = start;
        if (useLemma) {
            term = next.getLemma();
            while (!next.equals(end)) {
                next = next.next;
                if (!this.isUsefulForPhrase(next)) continue;
                term = term + " " + next.getLemma();
            }
        } else {
            term = next.getContent().toLowerCase();
            while (!next.equals(end)) {
                next = next.next;
                if (!this.isUsefulForPhrase(next)) continue;
                term = term + " " + next.getContent().toLowerCase();
            }
        }
        return term;
    }

    protected boolean isUsefulForPhrase(Word word) {
        int posIndex = word.getPOSIndex();
        if (posIndex == 3 || posIndex == 1 || posIndex == 9) {
            word.setIgnore(false);
            return true;
        }
        word.setIgnore(true);
        return false;
    }

    protected void readVocabularyMeta(String termFilename) {
        try {
            BufferedReader br = FileUtil.getTextReader(termFilename);
            String[] arrField = br.readLine().split("\t");
            this.minPhraseLength = Integer.parseInt(arrField[1]);
            this.maxPhraseLength = Integer.parseInt(arrField[2]);
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

