/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.ontology;

import dragon.nlp.Word;
import dragon.nlp.ontology.Ontology;
import dragon.nlp.ontology.SemanticNet;
import dragon.nlp.ontology.SimilarityMetric;
import dragon.nlp.tool.Lemmatiser;

public abstract class AbstractOntology
implements Ontology {
    private Lemmatiser lemmatiser;
    private boolean enable_tsd_option;
    private boolean enable_npp_option;
    private boolean enable_coordinate_option;
    private boolean enable_adjterm_option;
    private boolean enable_lemma_option;
    private String nonboundaryPunctuations;

    public AbstractOntology(Lemmatiser lemmatiser) {
        this.lemmatiser = lemmatiser;
        this.enable_tsd_option = false;
        this.enable_npp_option = false;
        this.enable_coordinate_option = false;
        this.enable_adjterm_option = false;
        this.enable_lemma_option = true;
        this.nonboundaryPunctuations = ".-'";
    }

    @Override
    public SemanticNet getSemanticNet() {
        return null;
    }

    @Override
    public SimilarityMetric getSimilarityMetric() {
        return null;
    }

    public void setNonBoundaryPunctuation(String punctuations) {
        this.nonboundaryPunctuations = punctuations;
    }

    public String getNonBoundaryPunctuation() {
        return this.nonboundaryPunctuations;
    }

    @Override
    public void setLemmaOption(boolean enabled) {
        this.enable_lemma_option = enabled;
    }

    @Override
    public boolean getLemmaOption() {
        return this.enable_lemma_option;
    }

    @Override
    public void setSenseDisambiguationOption(boolean enabled) {
        this.enable_tsd_option = enabled;
    }

    @Override
    public boolean getSenseDisambiguationOption() {
        return this.enable_tsd_option;
    }

    @Override
    public void setAdjectiveTermOption(boolean enabled) {
        this.enable_adjterm_option = enabled;
    }

    @Override
    public boolean getAdjectiveTermOption() {
        return this.enable_adjterm_option;
    }

    @Override
    public void setNPPOption(boolean enabled) {
        this.enable_npp_option = enabled;
    }

    @Override
    public boolean getNPPOption() {
        return this.enable_npp_option;
    }

    @Override
    public void setCoordinateOption(boolean enabled) {
        this.enable_coordinate_option = enabled;
    }

    @Override
    public boolean getCoordinateOption() {
        return this.enable_coordinate_option;
    }

    @Override
    public boolean isStartingWord(Word cur) {
        int posIndex = cur.getPOSIndex();
        if (posIndex == 1 || posIndex == 3) {
            return true;
        }
        return posIndex == 9 && cur.next != null && cur.next.getContent().equals("-");
    }

    protected boolean isBoundaryWord(Word curWord) {
        if (curWord.isPunctuation() && this.nonboundaryPunctuations.indexOf(curWord.getContent()) < 0) {
            return true;
        }
        if (curWord.prev != null && curWord.prev.getType() == 4) {
            return false;
        }
        int posIndex = curWord.getPOSIndex();
        if (posIndex == 2) {
            return true;
        }
        if (posIndex == 5) {
            if (!this.enable_npp_option) {
                return true;
            }
            if ("in for of".indexOf(curWord.getContent()) < 0) {
                return true;
            }
        }
        if (posIndex == 8) {
            if (!this.enable_coordinate_option) {
                return true;
            }
            if ("and or".indexOf(curWord.getContent()) < 0) {
                return true;
            }
        }
        return false;
    }

    protected String getLemma(Word word) {
        String lemma = word.getLemma();
        if (lemma == null) {
            lemma = word.getPOSIndex() >= 0 ? this.lemmatiser.lemmatize(word.getContent(), word.getPOSIndex()) : this.lemmatiser.lemmatize(word.getContent());
            word.setLemma(lemma);
        }
        return lemma;
    }

    protected String buildString(Word start, Word end, boolean useLemma) {
        String term;
        Word next = start;
        if (useLemma) {
            term = this.getLemma(next);
            while (!next.equals(end)) {
                next = next.next;
                if (!this.isUsefulForTerm(next)) continue;
                term = term + " " + this.getLemma(next);
            }
        } else {
            term = next.getContent().toLowerCase();
            while (!next.equals(end)) {
                next = next.next;
                if (!this.isUsefulForTerm(next)) continue;
                term = term + " " + next.getContent().toLowerCase();
            }
        }
        return term;
    }

    protected boolean isUsefulForTerm(Word word) {
        if (word.prev != null && word.prev.isPunctuation()) {
            if (word.prev.getContent().charAt(0) == '\'') {
                word.setIgnore(true);
                return false;
            }
            if (word.isPunctuation()) {
                word.setIgnore(true);
                return false;
            }
            word.setIgnore(false);
            return true;
        }
        int posIndex = word.getPOSIndex();
        if (posIndex == 3 || posIndex == 1 || posIndex == 9) {
            word.setIgnore(false);
            return true;
        }
        word.setIgnore(true);
        return false;
    }
}

