/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Sentence;
import dragon.nlp.Token;
import dragon.nlp.Word;
import dragon.nlp.extract.AbstractTokenExtractor;
import dragon.nlp.extract.BasicConceptFilter;
import dragon.nlp.tool.Lemmatiser;
import java.util.ArrayList;

public class BasicTokenExtractor
extends AbstractTokenExtractor {
    public BasicTokenExtractor(Lemmatiser lemmatiser) {
        super(lemmatiser);
    }

    public BasicTokenExtractor(Lemmatiser lemmatiser, String stoplistFile) {
        super(lemmatiser);
        this.setConceptFilter(new BasicConceptFilter(stoplistFile));
    }

    @Override
    public ArrayList extractFromDoc(String content) {
        ArrayList list = this.parser.parseTokens(content);
        this.conceptList = new ArrayList();
        if (list == null) {
            return this.conceptList;
        }
        for (int i = 0; i < list.size(); ++i) {
            String value = (String)list.get(i);
            this.addToken(value, this.conceptList);
        }
        list.clear();
        return this.conceptList;
    }

    @Override
    public ArrayList extractFromSentence(Sentence sent) {
        ArrayList tokenList = new ArrayList();
        Word cur = sent.getFirstWord();
        while (cur != null) {
            if (cur.getType() != 4) {
                this.addToken(new String(cur.getContent()), tokenList);
            }
            cur = cur.next;
        }
        return tokenList;
    }

    private Token addToken(String value, ArrayList tokenList) {
        if (this.lemmatiser != null) {
            value = this.lemmatiser.lemmatize(value);
        }
        if (this.conceptFilter_enabled && !this.cf.keep(value)) {
            return null;
        }
        Token token = new Token(value);
        tokenList.add(token);
        return token;
    }
}

