/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Sentence;
import dragon.nlp.Term;
import dragon.nlp.Word;
import dragon.nlp.extract.AbstractTermExtractor;
import dragon.nlp.ontology.Ontology;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.Tagger;
import java.util.ArrayList;

public class BasicTermExtractor
extends AbstractTermExtractor {
    public BasicTermExtractor(Ontology ontology, Lemmatiser lemmatiser, Tagger tagger) {
        super(ontology, tagger, lemmatiser);
    }

    public void clearAllCaches() {
        if (this.abbrChecker != null) {
            this.abbrChecker.clearCachedAbbr();
        }
    }

    @Override
    public ArrayList extractFromSentence(Sentence sent) {
        Word cur = sent.getFirstWord();
        if (cur != null && cur.getPOSIndex() < 0) {
            this.tagger.tag(sent);
        }
        Term prevTerm = null;
        ArrayList termList = new ArrayList(10);
        while (cur != null) {
            if (!this.ontology.isStartingWord(cur)) {
                cur = cur.next;
                continue;
            }
            Term curTerm = this.lookup(cur, prevTerm, termList);
            if (curTerm == null) {
                cur = cur.next;
                continue;
            }
            cur = curTerm.getEndingWord().next;
            prevTerm = curTerm;
        }
        if (this.coordinatingCheck_enabled) {
            this.paraChecker.identifyParaElements(sent);
        }
        if (this.attributeCheck_enabled) {
            this.attrChecker.identifyAttributes(termList);
        }
        if (this.coordinatingTermPredict_enabled && this.coordinatingCheck_enabled) {
            termList = this.paraChecker.parallelTermPredict(termList);
        }
        if (this.compoundTermPredict_enabled) {
            termList = this.compTermFinder.predict(termList);
        }
        if (this.conceptFilter_enabled) {
            termList = this.filter(termList);
        }
        return termList;
    }

    protected Term lookup(Word starting, Term prevTerm, ArrayList termList) {
        try {
            Term term;
            if (this.abbreviation_enabled && starting.getContent().length() <= 6) {
                Term referredTerm;
                if (this.abbrChecker.contains(starting.getContent())) {
                    referredTerm = this.abbrChecker.get();
                } else if (this.abbrChecker.isAbbrOfLastTerm(starting, prevTerm)) {
                    this.abbrChecker.put(starting.getContent(), prevTerm);
                    referredTerm = prevTerm;
                } else {
                    referredTerm = null;
                }
                if (referredTerm != null) {
                    starting.setLemma(starting.getContent().toLowerCase());
                    Term term2 = new Term(starting);
                    term2.setCandidateCUI(referredTerm.getCandidateCUI());
                    term2.setCUI(referredTerm.getCUI());
                    term2.setCandidateTUI(referredTerm.getCandidateTUI());
                    term2.setTUI(referredTerm.getTUI());
                    term2.setReferral(referredTerm);
                    starting.setAssociatedConcept(term2);
                    termList.add(term2);
                    return term2;
                }
            }
            if (this.subconcept_enabled) {
                ArrayList list = this.ontology.findAllTerms(starting);
                if (list != null && list.size() > 0) {
                    termList.addAll(list);
                    term = (Term)list.get(0);
                } else {
                    term = null;
                }
            } else {
                term = this.ontology.findTerm(starting);
                if (term != null) {
                    termList.add(term);
                }
            }
            return term;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

