/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Phrase;
import dragon.nlp.Sentence;
import dragon.nlp.Word;
import dragon.nlp.extract.AbstractPhraseExtractor;
import dragon.nlp.ontology.Vocabulary;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.Tagger;
import java.util.ArrayList;

public class BasicPhraseExtractor
extends AbstractPhraseExtractor {
    protected boolean overlappedPhrase;

    public BasicPhraseExtractor(Vocabulary vocabulary, Lemmatiser lemmatiser, Tagger tagger) {
        this(vocabulary, lemmatiser, tagger, false);
    }

    public BasicPhraseExtractor(Vocabulary vocabulary, Lemmatiser lemmatiser, Tagger tagger, boolean overlappedPhrase) {
        super(vocabulary, tagger, lemmatiser);
        this.overlappedPhrase = overlappedPhrase;
    }

    @Override
    public ArrayList extractFromSentence(Sentence sent) {
        int posIndex;
        Word cur = sent.getFirstWord();
        if (cur != null && cur.getPOSIndex() < 0) {
            this.tagger.tag(sent);
        }
        while (cur != null) {
            posIndex = cur.getPOSIndex();
            if (posIndex == 3 && this.useAdj || posIndex == 1 || posIndex == 2 && this.useVerb) {
                cur.setLemma(this.lemmatiser.lemmatize(cur.getContent(), posIndex));
            } else {
                cur.setLemma(cur.getContent().toLowerCase());
            }
            cur = cur.next;
        }
        int lastPhraseEndPos = -1;
        cur = sent.getFirstWord();
        ArrayList phraseList = new ArrayList(30);
        while (cur != null) {
            Phrase curPhrase;
            if (!this.vocabulary.isStartingWord(cur)) {
                posIndex = cur.getPOSIndex();
                if (cur.getPosInSentence() > lastPhraseEndPos && (posIndex == 1 && this.useNoun || posIndex == 3 && this.useAdj || posIndex == 2 && this.useVerb)) {
                    this.addPhrase(cur, cur, false, false, phraseList);
                }
                cur = cur.next;
                continue;
            }
            Word end = this.vocabulary.findPhrase(cur);
            if (end == null || (curPhrase = this.addPhrase(cur, end, true, false, phraseList)) == null) {
                posIndex = cur.getPOSIndex();
                if (cur.getPosInSentence() > lastPhraseEndPos && (posIndex == 1 && this.useNoun || posIndex == 3 && this.useAdj || posIndex == 2 && this.useVerb)) {
                    this.addPhrase(cur, cur, false, false, phraseList);
                }
                cur = cur.next;
                continue;
            }
            Word start = cur;
            if (curPhrase.getWordNum() >= 2 && this.getSubConceptOption()) {
                while (cur != null && cur.getPosInSentence() <= end.getPosInSentence()) {
                    posIndex = cur.getPOSIndex();
                    if (cur.getPosInSentence() > lastPhraseEndPos && (posIndex == 1 && this.useNoun || posIndex == 3 && this.useAdj)) {
                        this.addPhrase(cur, cur, false, true, phraseList);
                    }
                    cur = cur.next;
                }
            }
            lastPhraseEndPos = end.getPosInSentence();
            if (this.overlappedPhrase) {
                cur = start.next;
                continue;
            }
            cur = end.next;
        }
        return phraseList;
    }

    protected Phrase addPhrase(Word start, Word end, boolean forRelation, boolean subphrase, ArrayList phraseList) {
        Phrase phrase = new Phrase(start, end);
        phrase.setSubConcept(subphrase);
        if (this.conceptFilter_enabled && !this.cf.keep(phrase.getName())) {
            return null;
        }
        if (forRelation) {
            start.setAssociatedConcept(phrase);
        }
        phrase.setFrequency(1);
        phraseList.add(phrase);
        return phrase;
    }
}

