/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Concept;
import dragon.nlp.Term;
import dragon.nlp.extract.ConceptFilter;
import dragon.util.EnvVariable;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;

public class BasicConceptFilter
implements ConceptFilter {
    private SortedArray stoplist;
    private SortedArray excludedTypeList;
    private SortedArray supportedTypeList;

    public BasicConceptFilter() {
        this.excludedTypeList = null;
        this.supportedTypeList = null;
        this.stoplist = null;
    }

    public BasicConceptFilter(String stoplistFile) {
        this.excludedTypeList = null;
        this.supportedTypeList = null;
        this.stoplist = this.loadlist(stoplistFile);
    }

    public BasicConceptFilter(String stoplistFile, String supportSTYFile, String excludeSTYFile) {
        this.excludedTypeList = this.loadlist(excludeSTYFile);
        this.supportedTypeList = this.loadlist(supportSTYFile);
        this.stoplist = this.loadlist(stoplistFile);
    }

    @Override
    public boolean keep(Concept concept) {
        if (concept.getConceptType() != 1) {
            return this.keep(concept.getName());
        }
        Term term = (Term)concept;
        if (term.isPredicted()) {
            return true;
        }
        if (this.isExcludedTerm(term)) {
            return false;
        }
        if (this.isStopTerm(term)) {
            return false;
        }
        return this.isSupportedTerm(term);
    }

    @Override
    public boolean keep(String concept) {
        return !this.isStopConcept(concept);
    }

    public boolean addExcludedSTY(String tui) {
        if (this.excludedTypeList == null) {
            this.excludedTypeList = new SortedArray();
        }
        this.excludedTypeList.add(tui);
        return true;
    }

    public boolean addMultiExcludedSTY(String tuis) {
        String[] arrTUI = tuis.split(";");
        for (int i = 0; i < arrTUI.length; ++i) {
            this.addExcludedSTY(arrTUI[i]);
        }
        return true;
    }

    public boolean addSupportedSTY(String tui) {
        if (this.supportedTypeList == null) {
            this.supportedTypeList = new SortedArray();
        }
        this.supportedTypeList.add(tui);
        return true;
    }

    public boolean addMultiSupportedSTY(String tuis) {
        String[] arrTUI = tuis.split(";");
        for (int i = 0; i < arrTUI.length; ++i) {
            this.addSupportedSTY(arrTUI[i]);
        }
        return true;
    }

    private boolean isStopConcept(String concept) {
        if (this.stoplist == null) {
            return false;
        }
        return this.stoplist.contains(concept.toLowerCase());
    }

    private boolean isStopTerm(Term term) {
        if (this.stoplist == null || term.getWordNum() >= 2) {
            return false;
        }
        return this.stoplist.contains(term.getName().toLowerCase());
    }

    private boolean isExcludedTerm(Term term) {
        int i;
        int num = term.getCandidateTUINum();
        if (num == 0) {
            return false;
        }
        for (i = 0; i < num && !this.isExcludedType(term.getCandidateTUI(i)); ++i) {
        }
        return i < num;
    }

    private boolean isSupportedTerm(Term term) {
        int i;
        int num = term.getCandidateTUINum();
        if (num == 0) {
            return true;
        }
        for (i = 0; i < num && !this.isSupportedType(term.getCandidateTUI(i)); ++i) {
        }
        return i < num;
    }

    private boolean isExcludedType(String tui) {
        if (tui == null || this.excludedTypeList == null) {
            return false;
        }
        return this.excludedTypeList.contains(tui);
    }

    private boolean isSupportedType(String tui) {
        if (tui == null || this.supportedTypeList == null) {
            return true;
        }
        return this.supportedTypeList.contains(tui);
    }

    private SortedArray loadlist(String filename) {
        try {
            if (filename == null || filename.trim().length() == 0) {
                return null;
            }
            if (!FileUtil.exist(filename) && FileUtil.exist(EnvVariable.getDragonHome() + "/" + filename)) {
                filename = EnvVariable.getDragonHome() + "/" + filename;
            }
            BufferedReader br = FileUtil.getTextReader(filename);
            String line = br.readLine();
            int total = Integer.parseInt(line);
            SortedArray list = new SortedArray(total);
            for (int i = 0; i < total; ++i) {
                line = br.readLine();
                int pos = line.indexOf(9);
                if (pos > 0) {
                    line = line.substring(0, pos);
                }
                list.add(line.trim().toLowerCase());
            }
            br.close();
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

