/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Term;
import dragon.nlp.Word;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class AttributeChecker {
    private SortedArray attributes;

    public AttributeChecker(String attributeFile) {
        this.loadAttributes(attributeFile);
    }

    public boolean loadAttributes(String filename) {
        try {
            int termNum;
            String content = FileUtil.readTextFile(filename);
            String[] arrTerms = content.split("\r\n");
            for (termNum = arrTerms.length; termNum > 0 && arrTerms[termNum - 1].trim().length() == 0; --termNum) {
            }
            this.attributes = new SortedArray(termNum);
            for (int i = 0; i < termNum; ++i) {
                this.attributes.add(i, arrTerms[i].toLowerCase());
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isAttribute(Term attr) {
        return this.attributes.contains(attr.toLemmaString());
    }

    public boolean isAttribute(String attr) {
        return this.attributes.contains(attr.toLowerCase());
    }

    public int identifyAttributes(ArrayList termList) {
        if (termList == null) {
            return 0;
        }
        if (termList.size() < 2) {
            return 0;
        }
        int count = 0;
        Term curTerm = (Term)termList.get(0);
        for (int i = 1; i < termList.size(); ++i) {
            Word word = curTerm.getEndingWord().next;
            Term nextTerm = (Term)termList.get(i);
            if (word.getPOSIndex() == 5 && "of for".indexOf(word.getContent().toLowerCase()) >= 0) {
                if (nextTerm.getStartingWord().getPosInSentence() - curTerm.getEndingWord().getPosInSentence() > 4 || this.isAttribute(curTerm)) {
                    // empty if block
                }
                curTerm.getStartingWord().setAssociatedConcept(null);
                nextTerm.addAttribute(curTerm);
                ++count;
                termList.remove(i - 1);
                --i;
                int groupNo = nextTerm.getEndingWord().getParallelGroup();
                if (groupNo > curTerm.getEndingWord().getParallelGroup()) {
                    Term term;
                    int j;
                    for (j = i + 1; j < termList.size() && (term = (Term)termList.get(j)).getEndingWord().getParallelGroup() == groupNo; ++j) {
                        term.addAttribute(curTerm);
                    }
                    i = j - 1;
                }
                curTerm = (Term)termList.get(i);
                continue;
            }
            curTerm = nextTerm;
        }
        return count;
    }
}

