/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Concept;
import dragon.nlp.Document;
import dragon.nlp.Paragraph;
import dragon.nlp.Sentence;
import dragon.nlp.Triple;
import dragon.nlp.Word;
import dragon.nlp.extract.ClauseFinder;
import dragon.nlp.extract.CoReference;
import dragon.nlp.extract.ConceptExtractor;
import dragon.nlp.extract.ConceptFilter;
import dragon.nlp.extract.CoordinatingChecker;
import dragon.nlp.extract.TripleExtractor;
import dragon.util.SortedArray;
import java.io.PrintWriter;
import java.util.ArrayList;

public abstract class AbstractTripleExtractor
implements TripleExtractor {
    protected ConceptExtractor conceptExtractor;
    protected ConceptFilter cf;
    protected CoReference coReference;
    protected ClauseFinder clauseFinder;
    protected CoordinatingChecker coordinatingChecker;
    protected ArrayList conceptList;
    protected ArrayList tripleList;
    protected boolean coReference_enabled;
    protected boolean semanticCheck_enabled;
    protected boolean relationCheck_enabled;
    protected boolean clauseIdentify_enabled;
    protected boolean coordinatingCheck_enabled;
    protected boolean conceptFilter_enabled;

    public AbstractTripleExtractor(ConceptExtractor te) {
        this.conceptExtractor = te;
        this.coReference_enabled = false;
        this.relationCheck_enabled = false;
        this.clauseIdentify_enabled = false;
        this.semanticCheck_enabled = true;
        this.coReference = new CoReference();
        this.clauseFinder = new ClauseFinder();
        this.coordinatingChecker = new CoordinatingChecker();
    }

    @Override
    public void initDocExtraction() {
        this.conceptExtractor.initDocExtraction();
    }

    @Override
    public ArrayList getConceptList() {
        return this.conceptList;
    }

    @Override
    public ArrayList getTripleList() {
        return this.tripleList;
    }

    @Override
    public ConceptExtractor getConceptExtractor() {
        return this.conceptExtractor;
    }

    @Override
    public boolean getFilteringOption() {
        return this.conceptFilter_enabled;
    }

    @Override
    public void setFilteringOption(boolean option) {
        this.conceptFilter_enabled = option;
    }

    @Override
    public void setConceptFilter(ConceptFilter cf) {
        this.cf = cf;
        this.conceptFilter_enabled = cf != null;
    }

    @Override
    public ConceptFilter getConceptFilter() {
        return this.cf;
    }

    @Override
    public void setCoordinatingCheckOption(boolean option) {
        this.coordinatingCheck_enabled = option;
    }

    @Override
    public boolean getCoordinatingCheckOption() {
        return this.coordinatingCheck_enabled;
    }

    @Override
    public void setCoReferenceOption(boolean option) {
        this.coReference_enabled = option;
    }

    @Override
    public boolean getCoReferenceOption() {
        return this.coReference_enabled;
    }

    @Override
    public boolean getSemanticCheckOption() {
        return this.semanticCheck_enabled;
    }

    @Override
    public void setSemanticCheckOption(boolean option) {
        this.semanticCheck_enabled = option;
    }

    @Override
    public boolean getRelationCheckOption() {
        return this.relationCheck_enabled;
    }

    @Override
    public void setRelationCheckOption(boolean option) {
        this.relationCheck_enabled = option;
    }

    @Override
    public boolean getClauseIdentifyOption() {
        return this.clauseIdentify_enabled;
    }

    @Override
    public void setClauseIdentifyOption(boolean option) {
        this.clauseIdentify_enabled = option;
    }

    @Override
    public void print(PrintWriter out) {
        this.print(out, this.conceptList, this.tripleList);
    }

    @Override
    public void print(PrintWriter out, ArrayList conceptList, ArrayList tripleList) {
        try {
            int i;
            for (i = 0; i < conceptList.size(); ++i) {
                Concept concept = (Concept)conceptList.get(i);
                out.write(concept.getName() + ": ");
                out.write(String.valueOf(concept.getFrequency()));
                if (concept.getEntryID() != null) {
                    out.write(", " + concept.getEntryID());
                }
                if (concept.getSemanticType() != null) {
                    out.write(", " + concept.getSemanticType());
                }
                out.write("\n");
            }
            for (i = 0; i < tripleList.size(); ++i) {
                Triple triple = (Triple)tripleList.get(i);
                out.write(triple.getFirstConcept().getName());
                out.write("<->");
                out.write(triple.getSecondConcept().getName());
                out.write(40);
                out.write(String.valueOf(triple.getFrequency()));
                out.write(41);
                out.write("\n");
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean extractFromDoc(String doc) {
        return this.extractFromDoc(this.conceptExtractor.getDocumentParser().parse(doc));
    }

    @Override
    public boolean extractFromDoc(Document doc) {
        this.conceptList = new ArrayList();
        this.tripleList = new ArrayList();
        Paragraph pg = doc.getFirstParagraph();
        while (pg != null) {
            Sentence sent = pg.getFirstSentence();
            while (sent != null) {
                ArrayList curTermList;
                if (sent.getFirstWord() != null && (curTermList = this.conceptExtractor.extractFromSentence(sent)) != null) {
                    this.conceptList.addAll(curTermList);
                    ArrayList curTripleList = this.extractFromSentence(sent);
                    if (curTripleList != null) {
                        this.tripleList.addAll(curTripleList);
                        curTripleList.clear();
                    }
                    curTermList.clear();
                }
                sent = sent.next;
            }
            pg = pg.next;
        }
        return true;
    }

    @Override
    public SortedArray mergeTriples(SortedArray mergedConceptList, ArrayList tripleList) {
        SortedArray newList = new SortedArray();
        for (int i = 0; i < tripleList.size(); ++i) {
            int right;
            Triple triple = (Triple)tripleList.get(i);
            int left = mergedConceptList.binarySearch(triple.getFirstConcept());
            if (left < 0 || (right = mergedConceptList.binarySearch(triple.getSecondConcept())) < 0) continue;
            Triple newTriple = mergedConceptList.getComparator().compare(mergedConceptList.get(left), mergedConceptList.get(right)) > 0 ? new Triple((Concept)mergedConceptList.get(right), (Concept)mergedConceptList.get(left)) : new Triple((Concept)mergedConceptList.get(left), (Concept)mergedConceptList.get(right));
            if (!newList.add(newTriple)) {
                ((Triple)newList.get(newList.insertedPos())).addFrequency(triple.getFrequency());
                continue;
            }
            newTriple.setFrequency(triple.getFrequency());
            newTriple.setTUI(triple.getTUI());
            newTriple.setCandidateTUI(triple.getCandidateTUI());
            newTriple.setIndex(newList.size() - 1);
        }
        return newList;
    }

    protected boolean checkCoordinateTerms(Concept first, Concept second) {
        Word cur = first.getEndingWord().next;
        if (cur == null || !cur.getContent().equalsIgnoreCase("and")) {
            return false;
        }
        int gap = second.getStartingWord().getPosInSentence() - cur.getPosInSentence();
        if (gap < 1 || gap > 2) {
            return false;
        }
        cur = first.getStartingWord().prev;
        if (cur != null) {
            if (cur.getContent().equalsIgnoreCase("of") || cur.getContent().equalsIgnoreCase("between")) {
                return false;
            }
            cur = cur.prev;
            if (cur != null && (cur.getContent().equalsIgnoreCase("of") || cur.getContent().equalsIgnoreCase("between"))) {
                return false;
            }
        }
        return true;
    }
}

