/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Term;
import dragon.nlp.extract.Abbreviation;
import dragon.nlp.extract.AbstractConceptExtractor;
import dragon.nlp.extract.AttributeChecker;
import dragon.nlp.extract.CompoundTermFinder;
import dragon.nlp.extract.CoordinatingChecker;
import dragon.nlp.extract.TermExtractor;
import dragon.nlp.ontology.Ontology;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.Tagger;
import dragon.util.FileUtil;
import java.io.PrintWriter;
import java.util.ArrayList;

public abstract class AbstractTermExtractor
extends AbstractConceptExtractor
implements TermExtractor {
    protected Ontology ontology;
    protected Tagger tagger;
    protected Lemmatiser lemmatiser;
    protected boolean semanticCheck_enabled;
    protected boolean coordinatingTermPredict_enabled;
    protected boolean compoundTermPredict_enabled;
    protected boolean attributeCheck_enabled;
    protected boolean coordinatingCheck_enabled;
    protected boolean abbreviation_enabled;
    protected AttributeChecker attrChecker;
    protected CoordinatingChecker paraChecker;
    protected Abbreviation abbrChecker;
    protected CompoundTermFinder compTermFinder;

    public AbstractTermExtractor(Ontology ontology, Tagger tagger, Lemmatiser lemmatiser) {
        this.tagger = tagger;
        this.ontology = ontology;
        this.lemmatiser = lemmatiser;
        this.attrChecker = null;
        this.paraChecker = new CoordinatingChecker();
        this.abbrChecker = new Abbreviation();
        this.compTermFinder = new CompoundTermFinder();
        this.attrChecker = null;
        this.attributeCheck_enabled = false;
        this.semanticCheck_enabled = true;
        this.coordinatingTermPredict_enabled = false;
        this.compoundTermPredict_enabled = false;
        this.abbreviation_enabled = true;
        this.coordinatingCheck_enabled = true;
    }

    public boolean isExtractionMerged() {
        return false;
    }

    @Override
    public boolean supportConceptName() {
        return true;
    }

    @Override
    public boolean supportConceptEntry() {
        return true;
    }

    @Override
    public Ontology getOntology() {
        return this.ontology;
    }

    @Override
    public Tagger getPOSTagger() {
        return this.tagger;
    }

    @Override
    public Lemmatiser getLemmatiser() {
        return this.lemmatiser;
    }

    @Override
    public void setLemmatiser(Lemmatiser lemmatiser) {
        this.lemmatiser = lemmatiser;
    }

    @Override
    public void setSubConceptOption(boolean option) {
        this.subconcept_enabled = option;
        if (this.compTermFinder != null) {
            this.compTermFinder.setSubTermOption(option);
        }
    }

    @Override
    public void setCoordinatingCheckOption(boolean option) {
        this.coordinatingCheck_enabled = option;
    }

    @Override
    public boolean getCoordinatingCheckOption() {
        return this.coordinatingCheck_enabled;
    }

    @Override
    public void setAbbreviationOption(boolean option) {
        this.abbreviation_enabled = option;
    }

    @Override
    public boolean getAbbreviationOption() {
        return this.abbreviation_enabled;
    }

    @Override
    public void setAttributeCheckOption(boolean option) {
        this.attributeCheck_enabled = option;
    }

    @Override
    public boolean getAttributeCheckOption() {
        return this.attributeCheck_enabled;
    }

    @Override
    public boolean enableAttributeCheckOption(AttributeChecker checker) {
        this.attrChecker = checker;
        this.attributeCheck_enabled = true;
        return true;
    }

    @Override
    public boolean getSemanticCheckOption() {
        return this.semanticCheck_enabled;
    }

    @Override
    public void setSemanticCheckOption(boolean option) {
        this.semanticCheck_enabled = option;
    }

    @Override
    public boolean getCoordinatingTermPredictOption() {
        return this.coordinatingTermPredict_enabled;
    }

    @Override
    public void setCoordinatingTermPredictOption(boolean option) {
        this.coordinatingTermPredict_enabled = option;
    }

    @Override
    public boolean getCompoundTermPredictOption() {
        return this.compoundTermPredict_enabled;
    }

    @Override
    public void setCompoundTermPredictOption(boolean option) {
        this.compoundTermPredict_enabled = option;
    }

    @Override
    public boolean enableCompoundTermPredictOption(String suffixList) {
        this.compTermFinder = new CompoundTermFinder(suffixList);
        this.compoundTermPredict_enabled = true;
        return true;
    }

    @Override
    public void initDocExtraction() {
        if (this.abbrChecker != null) {
            this.abbrChecker.clearCachedAbbr();
        }
    }

    @Override
    public void print(PrintWriter out, ArrayList list) {
        try {
            for (int i = 0; i < list.size(); ++i) {
                int j;
                Term term = (Term)list.get(i);
                out.write(term.toString());
                for (j = 0; j < term.getAttributeNum(); ++j) {
                    out.write(47);
                    out.write(term.getAttribute(j).toString());
                }
                out.write(40);
                out.write(String.valueOf(term.getFrequency()));
                out.write(41);
                String[] arrStr = term.getCandidateTUI();
                if (arrStr != null) {
                    out.write(": ");
                    for (j = 0; j < arrStr.length; ++j) {
                        out.write(arrStr[j]);
                        if (j == arrStr.length - 1) {
                            out.write(" (");
                            continue;
                        }
                        out.write(59);
                    }
                    arrStr = term.getCandidateCUI();
                    for (j = 0; j < arrStr.length; ++j) {
                        out.write(arrStr[j]);
                        if (term.getCUI() != null && term.getCUI().equalsIgnoreCase(arrStr[j])) {
                            out.write("*");
                        }
                        if (j == arrStr.length - 1) {
                            out.write(41);
                            continue;
                        }
                        out.write(44);
                    }
                }
                if (term.isPredicted()) {
                    out.write("(Predicted)");
                }
                out.write("\r\n");
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void extractTermFromFile(String filename) {
        PrintWriter out1 = FileUtil.getPrintWriter(filename + ".term");
        PrintWriter out2 = FileUtil.getPrintWriter(filename + ".mergedterm");
        ArrayList list = this.extractFromDoc(FileUtil.readTextFile(filename));
        try {
            this.print(out1, list);
            out1.close();
            this.print(out2, this.mergeConceptByName(list));
            out1.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected ArrayList filter(ArrayList termList) {
        for (int i = 0; i < termList.size(); ++i) {
            Term term = (Term)termList.get(i);
            if (this.cf.keep(term)) continue;
            term.getStartingWord().setAssociatedConcept(null);
            termList.remove(i);
            --i;
        }
        return termList;
    }
}

