/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.extract.AbstractConceptExtractor;
import dragon.nlp.extract.PhraseExtractor;
import dragon.nlp.ontology.Vocabulary;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.Tagger;

public abstract class AbstractPhraseExtractor
extends AbstractConceptExtractor
implements PhraseExtractor {
    protected Lemmatiser lemmatiser;
    protected Tagger tagger;
    protected Vocabulary vocabulary;
    protected boolean useNoun;
    protected boolean useAdj;
    protected boolean useVerb;

    public AbstractPhraseExtractor(Vocabulary vocabulary, Tagger tagger, Lemmatiser lemmatiser) {
        this.lemmatiser = lemmatiser;
        this.tagger = tagger;
        this.vocabulary = vocabulary;
        this.useNoun = false;
        this.useAdj = false;
        this.useVerb = false;
    }

    @Override
    public void setSingleNounOption(boolean option) {
        this.useNoun = option;
    }

    @Override
    public boolean getSingleNounOption() {
        return this.useNoun;
    }

    @Override
    public void setSingleVerbOption(boolean option) {
        this.useVerb = option;
    }

    @Override
    public boolean getSingleVerbOption() {
        return this.useVerb;
    }

    @Override
    public void setSingleAdjectiveOption(boolean option) {
        this.useAdj = option;
    }

    @Override
    public boolean getSingleAdjectiveOption() {
        return this.useAdj;
    }

    @Override
    public boolean supportConceptName() {
        return true;
    }

    @Override
    public boolean supportConceptEntry() {
        return false;
    }

    @Override
    public Lemmatiser getLemmatiser() {
        return this.lemmatiser;
    }

    @Override
    public void setLemmatiser(Lemmatiser lemmatiser) {
        this.lemmatiser = lemmatiser;
    }

    @Override
    public Tagger getPOSTagger() {
        return this.tagger;
    }

    @Override
    public Vocabulary getVocabulary() {
        return this.vocabulary;
    }

    @Override
    public void initDocExtraction() {
    }
}

