/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp.extract;

import dragon.nlp.Concept;
import dragon.nlp.Document;
import dragon.nlp.DocumentParser;
import dragon.nlp.Paragraph;
import dragon.nlp.Sentence;
import dragon.nlp.compare.ConceptEntryIDComparator;
import dragon.nlp.compare.ConceptNameComparator;
import dragon.nlp.extract.ConceptExtractor;
import dragon.nlp.extract.ConceptFilter;
import dragon.nlp.extract.EngDocumentParser;
import dragon.util.SortedArray;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;

public abstract class AbstractConceptExtractor
implements ConceptExtractor {
    protected ArrayList conceptList = null;
    protected boolean conceptFilter_enabled = false;
    protected boolean subconcept_enabled = false;
    protected ConceptFilter cf = null;
    protected DocumentParser parser = new EngDocumentParser();

    @Override
    public void setSubConceptOption(boolean option) {
        this.subconcept_enabled = option;
    }

    @Override
    public boolean getSubConceptOption() {
        return this.subconcept_enabled;
    }

    @Override
    public boolean getFilteringOption() {
        return this.conceptFilter_enabled;
    }

    @Override
    public void setFilteringOption(boolean option) {
        this.conceptFilter_enabled = option;
    }

    @Override
    public void setConceptFilter(ConceptFilter cf) {
        this.cf = cf;
        this.conceptFilter_enabled = cf != null;
    }

    @Override
    public ConceptFilter getConceptFilter() {
        return this.cf;
    }

    @Override
    public ArrayList getConceptList() {
        return this.conceptList;
    }

    @Override
    public void print(PrintWriter out) {
        if (this.conceptList == null || this.conceptList.size() == 0) {
            return;
        }
        this.print(out, this.conceptList);
    }

    @Override
    public void print(PrintWriter out, ArrayList conceptList) {
        try {
            out.write(conceptList.size() + "\n");
            for (int i = 0; i < conceptList.size(); ++i) {
                Concept t = (Concept)conceptList.get(i);
                out.write(t.getName() + "\t" + t.getFrequency() + "\n");
                out.flush();
            }
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public SortedArray mergeConceptByEntryID(ArrayList termList) {
        return this.mergeTerms(termList, new ConceptEntryIDComparator());
    }

    @Override
    public SortedArray mergeConceptByName(ArrayList termList) {
        return this.mergeTerms(termList, new ConceptNameComparator());
    }

    private SortedArray mergeTerms(ArrayList termList, Comparator comparator) {
        SortedArray newList = new SortedArray(comparator);
        for (int i = 0; i < termList.size(); ++i) {
            Concept newTerm;
            Concept oldTerm = (Concept)termList.get(i);
            int pos = newList.binarySearch(oldTerm);
            if (pos >= 0) {
                newTerm = (Concept)newList.get(pos);
                newTerm.addFrequency(oldTerm.getFrequency());
                continue;
            }
            pos = pos * -1 - 1;
            newTerm = oldTerm.copy();
            newTerm.setIndex(newList.size());
            newList.add(pos, newTerm);
        }
        return newList;
    }

    @Override
    public synchronized ArrayList extractFromDoc(String doc) {
        return this.extractFromDoc(this.parser.parse(doc));
    }

    @Override
    public synchronized ArrayList extractFromDoc(Document doc) {
        try {
            this.conceptList = new ArrayList(20);
            if (doc == null) {
                return this.conceptList;
            }
            Paragraph pg = doc.getFirstParagraph();
            while (pg != null) {
                Sentence sent = pg.getFirstSentence();
                while (sent != null) {
                    ArrayList curTermList;
                    if (sent.getFirstWord() != null && (curTermList = this.extractFromSentence(sent)) != null) {
                        this.conceptList.addAll(curTermList);
                        curTermList.clear();
                    }
                    sent = sent.next;
                }
                pg = pg.next;
            }
            return this.conceptList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DocumentParser getDocumentParser() {
        return this.parser;
    }

    @Override
    public void setDocumentParser(DocumentParser parser) {
        this.parser = parser;
    }
}

